/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.attribute;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkConverter;
import hellfirepvp.astralsorcery.common.constellation.perk.ProgressGatedPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.types.IConverterProvider;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;

public abstract class AttributeConverterPerk
extends ProgressGatedPerk
implements IConverterProvider {
    private List<PerkConverter> converters = Lists.newArrayList();

    public AttributeConverterPerk(String name, int x, int y) {
        super(name, x, y);
    }

    public AttributeConverterPerk(ResourceLocation name, int x, int y) {
        super(name, x, y);
    }

    public <T> T addConverter(PerkConverter converter) {
        this.converters.add(converter);
        return (T)this;
    }

    public <T> T addRangedConverter(double radius, PerkConverter converter) {
        this.converters.add(converter.asRangedConverter(new Point2D.Double(this.getOffset().getX(), this.getOffset().getY()), radius));
        return (T)this;
    }

    public List<PerkConverter> provideConverters(EntityPlayer player, Side side) {
        if (this.modifiersDisabled(player, side)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.converters);
    }

    @Override
    public void applyPerkLogic(EntityPlayer player, Side side) {
    }

    @Override
    public void removePerkLogic(EntityPlayer player, Side side) {
    }
}

