/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.cape.impl;

import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.cape.CapeArmorEffect;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CapeEffectPelotrio
extends CapeArmorEffect {
    private static float chanceSpawnPick = 0.8f;
    private static float chanceSpawnAxe = 0.8f;
    private static float chanceSpawnSword = 0.5f;
    private static float swordAttackDamage = 4.0f;
    private static int ticksSwordAttacks = 6;
    private static int ticksBreakBlockPick = 4;
    private static int ticksBreakBlockAxe = 2;

    public CapeEffectPelotrio(NBTTagCompound cmp) {
        super(cmp, "pelotrio");
    }

    @Override
    public IConstellation getAssociatedConstellation() {
        return Constellations.pelotrio;
    }

    public float getChanceSpawnPick() {
        return chanceSpawnPick;
    }

    public float getChanceSpawnAxe() {
        return chanceSpawnAxe;
    }

    public float getChanceSpawnSword() {
        return chanceSpawnSword;
    }

    public static float getSwordAttackDamage() {
        return swordAttackDamage;
    }

    public static int getTicksSwordAttacks() {
        return ticksSwordAttacks;
    }

    public static int getTicksBreakBlockPick() {
        return ticksBreakBlockPick;
    }

    public static int getTicksBreakBlockAxe() {
        return ticksBreakBlockAxe;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void playActiveParticleTick(EntityPlayer pl) {
        this.playConstellationCapeSparkles(pl, 0.2f);
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        chanceSpawnPick = cfg.getFloat(this.getKey() + "Chance_Pickaxe", this.getConfigurationSection(), chanceSpawnPick, 0.0f, 1.0f, "Defines the chance of a spectral pickaxe spawning that's mining for you for a bit when you mine a block.");
        chanceSpawnAxe = cfg.getFloat(this.getKey() + "Chance_Axe", this.getConfigurationSection(), chanceSpawnAxe, 0.0f, 1.0f, "Defines the chance of a spectral axe spawning that's chopping logs and leaves for you for a bit when you break a log or leaf.");
        chanceSpawnSword = cfg.getFloat(this.getKey() + "Chance_Sword", this.getConfigurationSection(), chanceSpawnSword, 0.0f, 1.0f, "Defines the chance of a spectral sword spawning that fights mobs nearby for a bit when you attack a mob.");
        swordAttackDamage = cfg.getFloat(this.getKey() + "Sword_Attack", this.getConfigurationSection(), swordAttackDamage, 0.1f, 32.0f, "Defines the damage the sword does per attack");
        ticksSwordAttacks = cfg.getInt(this.getKey() + "Ticks_Sword", this.getConfigurationSection(), ticksSwordAttacks, 1, 100, "Definies how many ticks are at least between sword attacks the sword makes");
        ticksBreakBlockAxe = cfg.getInt(this.getKey() + "Ticks_Axe", this.getConfigurationSection(), ticksBreakBlockAxe, 1, 100, "Definies how long an axe is going to need to break a leaf or log");
        ticksBreakBlockPick = cfg.getInt(this.getKey() + "Ticks_Pickaxe", this.getConfigurationSection(), ticksBreakBlockPick, 1, 100, "Definies how long a pickaxe needs to break a block");
    }
}

