/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util;

import com.google.common.collect.Iterables;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.gui.journal.page.IJournalPage;
import hellfirepvp.astralsorcery.client.gui.journal.page.JournalPageAttunementRecipe;
import hellfirepvp.astralsorcery.client.gui.journal.page.JournalPageConstellationRecipe;
import hellfirepvp.astralsorcery.client.gui.journal.page.JournalPageDiscoveryRecipe;
import hellfirepvp.astralsorcery.client.gui.journal.page.JournalPageLightProximityRecipe;
import hellfirepvp.astralsorcery.client.gui.journal.page.JournalPageRecipe;
import hellfirepvp.astralsorcery.client.gui.journal.page.JournalPageText;
import hellfirepvp.astralsorcery.client.gui.journal.page.JournalPageTraitRecipe;
import hellfirepvp.astralsorcery.common.base.Mods;
import hellfirepvp.astralsorcery.common.crafting.altar.AbstractAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.AltarRecipeRegistry;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.AttunementRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.ConstellationRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.DiscoveryRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.TraitRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.AbstractRecipeAccessor;
import hellfirepvp.astralsorcery.common.crafting.helper.AccessibleRecipeAdapater;
import hellfirepvp.astralsorcery.common.data.research.ResearchNode;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.util.CraftingRecipeHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;

public class JournalRecipeDisplayRecovery {
    private JournalRecipeDisplayRecovery() {
    }

    public static void attemptRecipeRecovery() {
        if (!Mods.CRAFTTWEAKER.isPresent()) {
            return;
        }
        int rec = 0;
        for (ResearchProgression prog : ResearchProgression.values()) {
            for (ResearchNode rn : prog.getResearchNodes()) {
                HashMap<Integer, IJournalPage> update = new HashMap<Integer, IJournalPage>();
                List<IJournalPage> pages = rn.getPages();
                block13: for (int i = 0; i < pages.size(); ++i) {
                    IJournalPage page = pages.get(i);
                    RecoveryType rt = JournalRecipeDisplayRecovery.getRecoveryType(page);
                    if (rt == null) continue;
                    switch (rt) {
                        case CRAFTING: {
                            IRecipe actual = ((JournalPageRecipe)page).recipe.getParentRecipe();
                            List<IRecipe> matchingRecipes = CraftingRecipeHelper.findRecipesWithOutput(actual.func_77571_b());
                            boolean found = false;
                            for (IRecipe ir : matchingRecipes) {
                                if (!ir.getRegistryName().equals((Object)actual.getRegistryName())) continue;
                                found = true;
                                break;
                            }
                            if (found) continue block13;
                            ++rec;
                            update.put(i, JournalRecipeDisplayRecovery.findReplacementPage(actual.func_77571_b()));
                            continue block13;
                        }
                        case LIGHT_CRAFTING: {
                            IRecipe ir;
                            AccessibleRecipeAdapater recipeAd = ((JournalPageLightProximityRecipe)page).shapedLightProxRecipe;
                            List<IRecipe> matchingRecipes = CraftingRecipeHelper.findRecipesWithOutput(recipeAd.func_77571_b());
                            boolean found = false;
                            ir = matchingRecipes.iterator();
                            while (ir.hasNext()) {
                                IRecipe ir2 = ir.next();
                                if (!ir2.getRegistryName().equals((Object)recipeAd.getRegistryName())) continue;
                                found = true;
                                break;
                            }
                            if (found) continue block13;
                            ++rec;
                            update.put(i, JournalRecipeDisplayRecovery.findReplacementPage(recipeAd.func_77571_b()));
                            continue block13;
                        }
                        case ALTAR: {
                            TileAltar.AltarLevel al = JournalRecipeDisplayRecovery.guessAltarLevel(page);
                            if (al == null) continue block13;
                            DiscoveryRecipe currentRecipe = null;
                            ItemStack outputMatch = ItemStack.field_190927_a;
                            switch (al) {
                                case DISCOVERY: {
                                    currentRecipe = ((JournalPageDiscoveryRecipe)page).recipeToRender;
                                    outputMatch = currentRecipe.getOutputForMatching();
                                    break;
                                }
                                case ATTUNEMENT: {
                                    currentRecipe = ((JournalPageAttunementRecipe)page).recipe;
                                    outputMatch = currentRecipe.getOutputForMatching();
                                    break;
                                }
                                case CONSTELLATION_CRAFT: {
                                    currentRecipe = ((JournalPageConstellationRecipe)page).recipe;
                                    outputMatch = currentRecipe.getOutputForMatching();
                                    break;
                                }
                                case TRAIT_CRAFT: {
                                    currentRecipe = ((JournalPageTraitRecipe)page).recipe;
                                    outputMatch = currentRecipe.getOutputForMatching();
                                    break;
                                }
                            }
                            if (outputMatch.func_190926_b() || currentRecipe == null) continue block13;
                            List<AbstractAltarRecipe> recipesMatched = AltarRecipeRegistry.getAltarRecipesByOutput(outputMatch, al);
                            boolean found = false;
                            for (AbstractAltarRecipe aar : recipesMatched) {
                                if (!aar.equals(currentRecipe)) continue;
                                found = true;
                                break;
                            }
                            if (found) continue block13;
                            ++rec;
                            update.put(i, JournalRecipeDisplayRecovery.findReplacementPage(outputMatch));
                            continue block13;
                        }
                    }
                }
                for (Map.Entry entry : update.entrySet()) {
                    rn.getPages().set((Integer)entry.getKey(), (IJournalPage)entry.getValue());
                }
            }
        }
        if (rec > 0) {
            AstralSorcery.log.info("Recovered " + rec + " changed recipes into journal!");
        }
    }

    @Nonnull
    private static IJournalPage findReplacementPage(ItemStack output) {
        List<IRecipe> matchingRecipes = CraftingRecipeHelper.findRecipesWithOutput(output);
        if (!matchingRecipes.isEmpty()) {
            IRecipe recipe = (IRecipe)Iterables.getFirst(matchingRecipes, null);
            return new JournalPageRecipe(new AccessibleRecipeAdapater(recipe, AbstractRecipeAccessor.buildAccessorFor(recipe)));
        }
        List<AbstractAltarRecipe> recipesMatched = AltarRecipeRegistry.getAltarRecipesByOutput(output, TileAltar.AltarLevel.DISCOVERY);
        if (!recipesMatched.isEmpty()) {
            return new JournalPageDiscoveryRecipe((DiscoveryRecipe)Iterables.getFirst(recipesMatched, null));
        }
        recipesMatched = AltarRecipeRegistry.getAltarRecipesByOutput(output, TileAltar.AltarLevel.ATTUNEMENT);
        if (!recipesMatched.isEmpty()) {
            return new JournalPageAttunementRecipe((AttunementRecipe)Iterables.getFirst(recipesMatched, null));
        }
        recipesMatched = AltarRecipeRegistry.getAltarRecipesByOutput(output, TileAltar.AltarLevel.CONSTELLATION_CRAFT);
        if (!recipesMatched.isEmpty()) {
            return new JournalPageConstellationRecipe((ConstellationRecipe)Iterables.getFirst(recipesMatched, null));
        }
        recipesMatched = AltarRecipeRegistry.getAltarRecipesByOutput(output, TileAltar.AltarLevel.TRAIT_CRAFT);
        if (!recipesMatched.isEmpty()) {
            return new JournalPageTraitRecipe((TraitRecipe)Iterables.getFirst(recipesMatched, null));
        }
        return new JournalPageText("astralsorcery.journal.recipe.removalinfo");
    }

    @Nullable
    private static RecoveryType getRecoveryType(IJournalPage page) {
        if (page instanceof JournalPageRecipe) {
            return RecoveryType.CRAFTING;
        }
        if (page instanceof JournalPageLightProximityRecipe) {
            return RecoveryType.LIGHT_CRAFTING;
        }
        if (page instanceof JournalPageDiscoveryRecipe || page instanceof JournalPageAttunementRecipe || page instanceof JournalPageConstellationRecipe || page instanceof JournalPageTraitRecipe) {
            return RecoveryType.ALTAR;
        }
        return null;
    }

    @Nullable
    private static TileAltar.AltarLevel guessAltarLevel(IJournalPage page) {
        if (page instanceof JournalPageTraitRecipe) {
            return TileAltar.AltarLevel.TRAIT_CRAFT;
        }
        if (page instanceof JournalPageConstellationRecipe) {
            return TileAltar.AltarLevel.CONSTELLATION_CRAFT;
        }
        if (page instanceof JournalPageAttunementRecipe) {
            return TileAltar.AltarLevel.ATTUNEMENT;
        }
        if (page instanceof JournalPageDiscoveryRecipe) {
            return TileAltar.AltarLevel.DISCOVERY;
        }
        return null;
    }

    public static enum RecoveryType {
        CRAFTING,
        LIGHT_CRAFTING,
        ALTAR;

    }
}

