/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.render.tile;

import hellfirepvp.astralsorcery.client.models.base.ASobservatory;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.common.entities.EntityObservatoryHelper;
import hellfirepvp.astralsorcery.common.tile.TileObservatory;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class TESRObservatory
extends TileEntitySpecialRenderer<TileObservatory> {
    private static final ASobservatory modelTelescope = new ASobservatory();
    private static final BindableResource texTelescope = AssetLibrary.loadTexture(AssetLoader.TextureLocation.MODELS, "base/observatory");

    public void render(TileObservatory te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        Entity ridden;
        Vector3 vector3 = new Vector3(x, y, z);
        if (vector3.length() >= 64.0) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && (ridden = Minecraft.func_71410_x().field_71439_g.func_184187_bx()) != null && ridden instanceof EntityObservatoryHelper && ((EntityObservatoryHelper)ridden).tryGetObservatory() != null) {
            ((EntityObservatoryHelper)ridden).applyObservatoryRotationsFrom(te, (EntityPlayer)player);
        }
        float prevYaw = te.prevObservatoryYaw;
        float yaw = te.observatoryYaw;
        float prevPitch = te.prevObservatoryPitch;
        float pitch = te.observatoryPitch;
        float iYaw = RenderingUtils.interpolateRotation(prevYaw + 180.0f, yaw + 180.0f, partialTicks);
        float iPitch = RenderingUtils.interpolateRotation(prevPitch, pitch, partialTicks);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)0.0625, (double)0.0625, (double)0.0625);
        RenderHelper.func_74518_a();
        this.renderModel(iYaw, iPitch);
        GlStateManager.func_179121_F();
        TextureHelper.refreshTextureBindState();
    }

    private void renderModel(float iYaw, float iPitch) {
        texTelescope.bind();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        Blending.DEFAULT.applyStateManager();
        Blending.DEFAULT.apply();
        modelTelescope.func_78088_a(null, iYaw, iPitch, 0.0f, 0.0f, 0.0f, 1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
    }

    public boolean isGlobalRenderer(TileObservatory te) {
        return true;
    }
}

