/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.event;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.util.ClientScreenshotCache;
import hellfirepvp.astralsorcery.client.util.UIGateway;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.client.PktRequestTeleport;
import hellfirepvp.astralsorcery.common.tile.TileCelestialGateway;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.data.WorldBlockPos;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientGatewayHandler {
    public static UIGateway.GatewayEntry focusingEntry = null;
    public static int focusTicks = 0;
    private static int screenshotCooldown = 0;
    private static WorldBlockPos lastScreenshotPos = null;
    private float fovPre = 70.0f;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (screenshotCooldown > 0 && --screenshotCooldown <= 0) {
            lastScreenshotPos = null;
            screenshotCooldown = 0;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        UIGateway ui = EffectHandler.getInstance().getUiGateway();
        if (ui != null && Minecraft.func_71410_x().field_71439_g.field_70170_p != null) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            TileCelestialGateway gate = MiscUtils.getTileAt((IBlockAccess)player.field_70170_p, Vector3.atEntityCorner((Entity)player).toBlockPos(), TileCelestialGateway.class, true);
            if (gate != null && gate.hasMultiblock() && gate.doesSeeSky()) {
                if (lastScreenshotPos != null) {
                    WorldBlockPos currentPos = WorldBlockPos.wrap(gate);
                    if (!lastScreenshotPos.equals((Object)currentPos)) {
                        lastScreenshotPos = null;
                        screenshotCooldown = 0;
                    }
                } else {
                    this.captureScreenshot(gate);
                }
                UIGateway.GatewayEntry entry = ui.findMatchingEntry(MathHelper.func_76142_g((float)player.field_70177_z), MathHelper.func_76142_g((float)player.field_70125_A));
                if (entry == null) {
                    focusingEntry = null;
                    focusTicks = 0;
                } else if (!Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d() && !Minecraft.func_71410_x().field_71439_g.func_70093_af()) {
                    focusTicks = 0;
                    focusingEntry = null;
                } else if (focusingEntry != null) {
                    if (!entry.equals(focusingEntry)) {
                        focusingEntry = null;
                        focusTicks = 0;
                    } else {
                        ++focusTicks;
                    }
                } else {
                    focusingEntry = entry;
                    focusTicks = 0;
                }
            } else {
                focusingEntry = null;
                focusTicks = 0;
            }
        } else {
            focusingEntry = null;
            focusTicks = 0;
        }
        if (focusingEntry != null) {
            Vector3 dir = ClientGatewayHandler.focusingEntry.relativePos.clone().add(ui.getPos()).subtract(Vector3.atEntityCorner((Entity)Minecraft.func_71410_x().field_71439_g).addY(1.62));
            Vector3 mov = dir.clone().normalize().multiply(0.25f).negate();
            Vector3 pos = ClientGatewayHandler.focusingEntry.relativePos.clone().add(ui.getPos());
            if (focusTicks > 40) {
                for (Vector3 v : MiscUtils.getCirclePositions(pos, dir, (double)EffectHandler.STATIC_EFFECT_RAND.nextFloat() * 0.3 + 0.2, EffectHandler.STATIC_EFFECT_RAND.nextInt(20) + 30)) {
                    EntityFXFacingParticle p = EffectHelper.genericGatewayFlareParticle(v.getX(), v.getY(), v.getZ());
                    Vector3 m = mov.clone().multiply(0.5 + (double)EffectHandler.STATIC_EFFECT_RAND.nextFloat() * 0.5);
                    p.gravity(0.004).scale(0.1f).motion(m.getX(), m.getY(), m.getZ());
                    switch (EffectHandler.STATIC_EFFECT_RAND.nextInt(4)) {
                        case 0: {
                            p.setColor(Color.WHITE);
                            break;
                        }
                        case 1: {
                            p.setColor(new Color(6927871));
                            break;
                        }
                        case 2: {
                            p.setColor(new Color(30975));
                            break;
                        }
                    }
                }
            } else {
                Vector3 to;
                EntityFXFacingParticle p;
                Vector3 v;
                float pc;
                int i;
                pos = ClientGatewayHandler.focusingEntry.relativePos.clone().multiply(0.8).add(ui.getPos());
                float perc = (float)focusTicks / 40.0f;
                List<Vector3> positions = MiscUtils.getCirclePositions(pos, dir.clone().negate(), (double)EffectHandler.STATIC_EFFECT_RAND.nextFloat() * 0.2 + 0.4, EffectHandler.STATIC_EFFECT_RAND.nextInt(6) + 25);
                block16: for (i = 0; i < positions.size(); ++i) {
                    pc = (float)i / (float)positions.size();
                    if (pc >= perc) continue;
                    v = positions.get(i);
                    p = EffectHelper.genericGatewayFlareParticle(v.getX(), v.getY(), v.getZ());
                    p.gravity(0.004).scale(0.08f);
                    if (EffectHandler.STATIC_EFFECT_RAND.nextInt(3) == 0) {
                        to = pos.clone().subtract(v);
                        to.normalize().multiply(0.02);
                        p.motion(to.getX(), to.getY(), to.getZ()).setAlphaMultiplier(0.1f);
                    }
                    switch (EffectHandler.STATIC_EFFECT_RAND.nextInt(4)) {
                        case 0: {
                            p.setColor(Color.WHITE);
                            continue block16;
                        }
                        case 1: {
                            p.setColor(new Color(6927871));
                            continue block16;
                        }
                        case 2: {
                            p.setColor(new Color(30975));
                            continue block16;
                        }
                    }
                }
                positions = MiscUtils.getCirclePositions(pos, dir, (double)EffectHandler.STATIC_EFFECT_RAND.nextFloat() * 0.2 + 0.4, EffectHandler.STATIC_EFFECT_RAND.nextInt(6) + 25);
                Collections.reverse(positions);
                block17: for (i = 0; i < positions.size(); ++i) {
                    pc = (float)i / (float)positions.size();
                    if (pc >= perc) continue;
                    v = positions.get(i);
                    p = EffectHelper.genericGatewayFlareParticle(v.getX(), v.getY(), v.getZ());
                    p.gravity(0.004).scale(0.08f);
                    if (EffectHandler.STATIC_EFFECT_RAND.nextInt(3) == 0) {
                        to = pos.clone().subtract(v);
                        to.normalize().multiply(0.02);
                        p.motion(to.getX(), to.getY(), to.getZ()).setAlphaMultiplier(0.1f);
                    }
                    switch (EffectHandler.STATIC_EFFECT_RAND.nextInt(4)) {
                        case 0: {
                            p.setColor(Color.WHITE);
                            continue block17;
                        }
                        case 1: {
                            p.setColor(new Color(6927871));
                            continue block17;
                        }
                        case 2: {
                            p.setColor(new Color(30975));
                            continue block17;
                        }
                    }
                }
            }
            if (focusTicks > 95) {
                Minecraft.func_71410_x().field_71439_g.func_70095_a(false);
                PacketChannel.CHANNEL.sendToServer((IMessage)new PktRequestTeleport(ClientGatewayHandler.focusingEntry.originalDimId, ClientGatewayHandler.focusingEntry.originalBlockPos));
                focusTicks = 0;
                focusingEntry = null;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void captureScreenshot(TileCelestialGateway gate) {
        ResourceLocation gatewayScreenshot = ClientScreenshotCache.tryQueryTextureFor(gate.func_145831_w().field_73011_w.getDimension(), gate.func_174877_v());
        if (gatewayScreenshot == null && Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.field_70125_A <= 0.0f && Minecraft.func_71410_x().field_71462_r == null && Minecraft.func_71410_x().field_71438_f.func_184382_g() > 200) {
            screenshotCooldown = 10;
            lastScreenshotPos = WorldBlockPos.wrap(gate);
            ClientScreenshotCache.takeViewScreenshotFor(gate.func_145831_w().field_73011_w.getDimension(), gate.func_174877_v());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @SideOnly(value=Side.CLIENT)
    public void onRenderTransform(TickEvent.RenderTickEvent event) {
        UIGateway ui = EffectHandler.getInstance().getUiGateway();
        if (ui != null) {
            if (event.phase == TickEvent.Phase.START) {
                this.fovPre = Minecraft.func_71410_x().field_71474_y.field_74334_X;
                if (focusTicks < 80) {
                    return;
                }
                float percDone = 1.0f - ((float)focusTicks - 80.0f + event.renderTickTime) / 15.0f;
                float targetFov = 10.0f;
                float diff = this.fovPre - targetFov;
                Minecraft.func_71410_x().field_71474_y.field_74334_X = Math.max(targetFov, targetFov + diff * percDone);
            } else {
                Minecraft.func_71410_x().field_71474_y.field_74334_X = this.fovPre;
            }
        }
    }
}

