/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.light;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.IComplexEffect;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.SpriteLibrary;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import org.lwjgl.opengl.GL11;

public class EffectLightbeam
implements IComplexEffect,
IComplexEffect.PreventRemoval {
    private final Vector3 from;
    private final Vector3 to;
    private final Vector3 aim;
    private final Vector3 aimPerp;
    private final double fromSize;
    private final double toSize;
    private int maxAge = 64;
    private int age = 0;
    private EntityComplexFX.AlphaFunction alphaFunction = EntityComplexFX.AlphaFunction.PYRAMID;
    private float alphaMultiplier = 1.0f;
    private float cR = 1.0f;
    private float cG = 1.0f;
    private float cB = 1.0f;
    private float cA = 1.0f;
    private double distanceCapSq = Config.maxEffectRenderDistanceSq;
    private boolean flagRemoved = true;

    public EffectLightbeam(Vector3 from, Vector3 to, double fromSize, double toSize) {
        this.from = from;
        this.to = to;
        this.aim = to.clone().subtract(from);
        this.aimPerp = this.aim.clone().perpendicular().normalize();
        this.fromSize = fromSize;
        this.toSize = toSize;
    }

    public EffectLightbeam(Vector3 from, Vector3 to, double size) {
        this(from, to, size, size);
    }

    public void setMaxAge(int newMax) {
        this.maxAge = newMax;
    }

    public void setDead() {
        this.age = this.maxAge;
    }

    public EffectLightbeam setDistanceCapSq(double distanceCapSq) {
        this.distanceCapSq = distanceCapSq;
        return this;
    }

    public EffectLightbeam setColorOverlay(float red, float green, float blue, float alpha) {
        this.cR = red;
        this.cG = green;
        this.cB = blue;
        this.cA = alpha;
        return this;
    }

    public EffectLightbeam setColorOverlay(Color color) {
        this.cR = (float)color.getRed() / 255.0f;
        this.cG = (float)color.getGreen() / 255.0f;
        this.cB = (float)color.getBlue() / 255.0f;
        this.cA = (float)color.getAlpha() / 255.0f;
        return this;
    }

    public EffectLightbeam setAlphaMultiplier(float alphaMultiplier) {
        this.alphaMultiplier = alphaMultiplier;
        return this;
    }

    public EffectLightbeam setAlphaFunction(@Nonnull EntityComplexFX.AlphaFunction function) {
        this.alphaFunction = function;
        return this;
    }

    @Override
    public boolean canRemove() {
        return this.age >= this.maxAge;
    }

    @Override
    public IComplexEffect.RenderTarget getRenderTarget() {
        return IComplexEffect.RenderTarget.RENDERLOOP;
    }

    @Override
    public boolean isRemoved() {
        return this.flagRemoved;
    }

    @Override
    public void flagAsRemoved() {
        this.flagRemoved = true;
    }

    @Override
    public void clearRemoveFlag() {
        this.flagRemoved = false;
    }

    @Override
    public void render(float pTicks) {
        Entity rView = Minecraft.func_71410_x().func_175606_aa();
        if (rView == null) {
            rView = Minecraft.func_71410_x().field_71439_g;
        }
        if (rView.func_70092_e(this.from.getX(), this.from.getY(), this.from.getZ()) > this.distanceCapSq) {
            return;
        }
        float tr = this.alphaFunction.getAlpha(this.age, this.maxAge);
        tr = (float)((double)tr * 0.6);
        GlStateManager.func_179094_E();
        this.removeOldTranslate(rView, pTicks);
        GlStateManager.func_179131_c((float)(this.cR * (tr *= this.alphaMultiplier)), (float)(this.cG * tr), (float)(this.cB * tr), (float)(this.cA * tr));
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179092_a((int)516, (float)0.001f);
        Blending.PREALPHA.applyStateManager();
        boolean lighting = GL11.glGetBoolean((int)2896);
        if (lighting) {
            GlStateManager.func_179140_f();
        }
        SpriteLibrary.spriteLightbeam.getResource().bindTexture();
        this.renderCurrentTextureAroundAxis(Math.toRadians(0.0));
        this.renderCurrentTextureAroundAxis(Math.toRadians(120.0));
        this.renderCurrentTextureAroundAxis(Math.toRadians(240.0));
        if (lighting) {
            GlStateManager.func_179145_e();
        }
        Blending.DEFAULT.applyStateManager();
        GlStateManager.func_179147_l();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    private void removeOldTranslate(Entity entity, float partialTicks) {
        double x = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double y = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double z = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)(-z));
    }

    private void renderCurrentTextureAroundAxis(double angle) {
        Vector3 perp = this.aimPerp.clone().rotate(angle, this.aim).normalize();
        Vector3 perpFrom = perp.clone().multiply(this.fromSize);
        Vector3 perpTo = perp.multiply(this.toSize);
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        Tuple<Double, Double> uvOffset = SpriteLibrary.spriteLightbeam.getUVOffset(this.age);
        double u = (Double)uvOffset.key;
        double v = (Double)uvOffset.value;
        double uWidth = SpriteLibrary.spriteLightbeam.getULength();
        double vHeight = SpriteLibrary.spriteLightbeam.getVLength();
        Vector3 vec = this.from.clone().add(perpFrom.clone().multiply(-1));
        buf.func_181662_b(vec.getX(), vec.getY(), vec.getZ()).func_187315_a(u, v + vHeight).func_181675_d();
        vec = this.from.clone().add(perpFrom);
        buf.func_181662_b(vec.getX(), vec.getY(), vec.getZ()).func_187315_a(u + uWidth, v + vHeight).func_181675_d();
        vec = this.to.clone().add(perpTo);
        buf.func_181662_b(vec.getX(), vec.getY(), vec.getZ()).func_187315_a(u + uWidth, v).func_181675_d();
        vec = this.to.clone().add(perpTo.clone().multiply(-1));
        buf.func_181662_b(vec.getX(), vec.getY(), vec.getZ()).func_187315_a(u, v).func_181675_d();
        tes.func_78381_a();
    }

    @Override
    public void tick() {
        ++this.age;
    }
}

