/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common.matching.matcher;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import wanion.lib.common.Util;
import wanion.lib.common.matching.AbstractMatching;
import wanion.lib.common.matching.matcher.AbstractMatcher;
import wanion.lib.common.matching.matcher.AnyDamageMatcher;
import wanion.lib.common.matching.matcher.DamagedMatcher;
import wanion.lib.common.matching.matcher.DisabledMatcher;
import wanion.lib.common.matching.matcher.EmptyMatcher;
import wanion.lib.common.matching.matcher.EnumMatcher;
import wanion.lib.common.matching.matcher.ItemStackMatcher;
import wanion.lib.common.matching.matcher.ModMatcher;
import wanion.lib.common.matching.matcher.NbtMatcher;
import wanion.lib.common.matching.matcher.OreDictMatcher;
import wanion.lib.common.matching.matcher.VanillaMatcher;

public enum MatcherEnum {
    DISABLED(DisabledMatcher.class),
    ENUM(EnumMatcher.class),
    EMPTY(EmptyMatcher.class, ItemStack::func_190926_b),
    ITEM_STACK(ItemStackMatcher.class, Util.not(ItemStack::func_190926_b)),
    DAMAGED(DamagedMatcher.class, ItemStack::func_77951_h),
    ANY_DAMAGE(AnyDamageMatcher.class, Util.not(ItemStack::func_190926_b)),
    NBT(NbtMatcher.class, ItemStack::func_77942_o),
    VANILLA(VanillaMatcher.class, Util::isFromVanilla),
    MOD(ModMatcher.class, Util.not(Util::isFromVanilla)),
    ORE_DICT(OreDictMatcher.class, Util::itemStackHasOres);

    private static final Map<String, MatcherEnum> nameToMatcherEnum;
    final Class<? extends AbstractMatcher<? extends AbstractMatcher<?>>> matcherClass;
    private final Predicate<ItemStack> accepts;
    final String lowerCaseName;

    private MatcherEnum(Class<? extends AbstractMatcher<?>> matcherClass) {
        this(matcherClass, i -> false);
    }

    private MatcherEnum(Class<? extends AbstractMatcher<?>> matcherClass, Predicate<ItemStack> accepts) {
        this.matcherClass = matcherClass;
        this.accepts = accepts;
        this.lowerCaseName = this.name().toLowerCase();
    }

    public boolean accepts(@Nonnull ItemStack itemStack) {
        return this.accepts.test(itemStack);
    }

    @Nonnull
    public static MatcherEnum getMatcherEnumByName(@Nonnull String name) {
        MatcherEnum matcherEnum = nameToMatcherEnum.get(name);
        return matcherEnum != null ? matcherEnum : EMPTY;
    }

    @Nonnull
    public AbstractMatcher<?> getMatcher(@Nonnull AbstractMatching<?> matching) {
        try {
            Constructor<AbstractMatcher<AbstractMatcher<?>>> constructor = this.matcherClass.getDeclaredConstructor(AbstractMatching.class);
            return constructor.newInstance(matching);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("This Should never happen: " + e);
        }
    }

    public String getLowerCaseName() {
        return this.lowerCaseName;
    }

    static {
        nameToMatcherEnum = new HashMap<String, MatcherEnum>();
        for (MatcherEnum matcherEnum : MatcherEnum.values()) {
            nameToMatcherEnum.put(matcherEnum.lowerCaseName, matcherEnum);
        }
    }
}

