/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common.matching;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import wanion.lib.common.ICopyable;
import wanion.lib.common.ISmartNBT;
import wanion.lib.common.control.IControlNameable;
import wanion.lib.common.matching.matcher.AbstractMatcher;
import wanion.lib.common.matching.matcher.ItemStackMatcher;
import wanion.lib.common.matching.matcher.MatcherEnum;

public abstract class AbstractMatching<M extends AbstractMatching<M>>
implements ISmartNBT,
ICopyable<M>,
IControlNameable {
    protected final List<ItemStack> itemStacks;
    protected final int number;
    protected AbstractMatcher<?> matcher = new ItemStackMatcher(this);

    public AbstractMatching(@Nonnull List<ItemStack> itemStacks, int number) {
        this(itemStacks, number, null);
    }

    public AbstractMatching(@Nonnull List<ItemStack> itemStacks, int number, NBTTagCompound tagToRead) {
        this.itemStacks = itemStacks;
        this.number = number;
        if (tagToRead != null) {
            this.readNBT(tagToRead);
        }
    }

    public final void resetMatcher() {
        this.matcher = this.getDefaultMatcher();
    }

    @Nonnull
    public abstract AbstractMatcher<?> getDefaultMatcher();

    public abstract void nextMatcher();

    public final AbstractMatcher<?> getMatcher() {
        return this.matcher;
    }

    public final void setMatcher(@Nonnull AbstractMatcher<?> matcher) {
        this.matcher = matcher.validate();
    }

    public final boolean matches(@Nonnull ItemStack otherItemStack) {
        return this.matcher.matches(otherItemStack);
    }

    public final void validate() {
        this.matcher = this.matcher.validate();
    }

    public final ItemStack getStack() {
        return this.itemStacks.get(this.number);
    }

    @Override
    @Nonnull
    public final NBTTagCompound writeNBT() {
        NBTTagCompound matcherNBT = new NBTTagCompound();
        matcherNBT.func_74768_a("number", this.number);
        matcherNBT.func_74778_a("matcherType", this.matcher.getMatcherEnum().getLowerCaseName());
        matcherNBT.func_74782_a("matcher", (NBTBase)this.matcher.writeNBT());
        this.customWriteNBT(matcherNBT);
        return matcherNBT;
    }

    @Override
    public final void readNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        AbstractMatcher<?> matcher = MatcherEnum.getMatcherEnumByName(nbtTagCompound.func_74779_i("matcherType")).getMatcher(this);
        matcher.readNBT(nbtTagCompound.func_74775_l("matcher"));
        this.setMatcher(matcher);
        this.customReadNBT(nbtTagCompound);
    }

    public void customWriteNBT(@Nonnull NBTTagCompound nbtTagCompound) {
    }

    public void customReadNBT(@Nonnull NBTTagCompound nbtTagCompound) {
    }

    @Override
    @Nonnull
    public final String getControlName() {
        return "wanionlib.matching.control";
    }

    public final int getNumber() {
        return this.number;
    }

    public final int hashCode() {
        return this.number;
    }
}

