/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;
import wanion.lib.common.MetaItem;

public final class Util {
    private Util() {
    }

    public static <T, E extends T> E getField(Class clas, String name, Object instance, Class<T> expectedClass) {
        try {
            Field field = clas.getDeclaredField(name);
            field.setAccessible(true);
            return (E)expectedClass.cast(field.get(instance));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T, E extends T> E getField(Class clas, String unobfuscatedName, String obfuscatedName, Object instance, Class<T> expectedClass) {
        try {
            Field field;
            try {
                field = clas.getDeclaredField(obfuscatedName);
            }
            catch (Exception e) {
                field = clas.getDeclaredField(unobfuscatedName);
            }
            field.setAccessible(true);
            return (E)expectedClass.cast(field.get(instance));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <E> void setField(Class clas, String name, Object instance, E newInstance) {
        try {
            Field field = clas.getDeclaredField(name);
            field.setAccessible(true);
            field.set(instance, newInstance);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nonnull
    public static String getModName(@Nonnull ItemStack itemStack) {
        Item item;
        if (itemStack == null || (item = itemStack.func_77973_b()) == null) {
            return "";
        }
        return item.delegate.name().func_110624_b();
    }

    public static boolean isFromVanilla(@Nonnull ItemStack itemStack) {
        return Util.getModName(itemStack).equals("minecraft");
    }

    public static boolean areFromSameMod(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        return Util.getModName(stack1).equals(Util.getModName(stack2));
    }

    public static <O> void fillArray(@Nonnull O[] array, @Nonnull O defaultInstance) {
        Arrays.fill(array, defaultInstance);
    }

    public static <O> O[] treeDimArrayToTwoDimArray(@Nonnull O[][] treeDimArray) {
        ArrayList<O> oList = new ArrayList<O>();
        for (O[] twoDimArray : treeDimArray) {
            if (twoDimArray == null) continue;
            oList.addAll(Arrays.asList(twoDimArray));
        }
        return oList.toArray();
    }

    public static ItemStack getStackFromIngredient(@Nonnull Ingredient ingredient) {
        ItemStack[] stacks = ingredient.func_193365_a();
        return stacks.length > 0 ? stacks[0] : ItemStack.field_190927_a;
    }

    public static String getOreNameFromOreIngredient(@Nonnull OreIngredient oreIngredient) {
        NonNullList ores = (NonNullList)Util.getField(OreIngredient.class, "ores", oreIngredient, NonNullList.class);
        List idToStackUn = (List)Util.getField(OreDictionary.class, "idToStackUn", null, List.class);
        if (idToStackUn == null) {
            return null;
        }
        for (int i = 0; i < idToStackUn.size(); ++i) {
            NonNullList stackList = (NonNullList)idToStackUn.get(i);
            if (stackList != ores) continue;
            return OreDictionary.getOreName((int)i);
        }
        return null;
    }

    public static <R> Predicate<R> not(@Nonnull Predicate<R> predicate) {
        return predicate.negate();
    }

    public static boolean itemStackHasOres(@Nonnull ItemStack itemStack) {
        return ((Map)Util.getField(OreDictionary.class, "stackToId", null, Map.class)).containsKey(MetaItem.get(itemStack));
    }
}

