/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.client.gui;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wanion.lib.client.gui.ITooltipSupplier;
import wanion.lib.client.gui.WGuiContainer;
import wanion.lib.client.gui.interaction.WInteraction;
import wanion.lib.client.gui.interaction.WKeyInteraction;
import wanion.lib.client.gui.interaction.WMouseInteraction;
import wanion.lib.common.WContainer;

@SideOnly(value=Side.CLIENT)
public abstract class WElement<E extends WElement<E>> {
    public static final ITooltipSupplier DEFAULT_WELEMENT_TOOLTIP_SUPPLIER = (interaction, stackSupplier) -> Collections.emptyList();
    public static final Supplier<ItemStack> DEFAULT_ITEMSTACK_SUPPLIER = () -> ItemStack.field_190927_a;
    private final Predicate<WInteraction> default_check = wInteraction -> wInteraction.isHovering(this);
    protected final WGuiContainer<?> wGuiContainer;
    private Predicate<WInteraction> foregroundCheck;
    private Predicate<WInteraction> interactionCheck;
    private Supplier<ItemStack> stackSupplier;
    private ITooltipSupplier tooltipSupplier;
    private final Class<E> elementClass;
    protected final int width;
    protected final int height;
    protected int x;
    protected int y;
    protected boolean enabled = true;

    public WElement(@Nonnull WGuiContainer<?> wGuiContainer) {
        this(wGuiContainer, 0, 0);
    }

    public WElement(@Nonnull WGuiContainer<?> wGuiContainer, int x, int y) {
        this(wGuiContainer, x, y, 0, 0);
    }

    public WElement(@Nonnull WGuiContainer<?> wGuiContainer, int x, int y, int width, int height) {
        this.wGuiContainer = wGuiContainer;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.foregroundCheck = this.default_check;
        this.interactionCheck = this.default_check;
        this.stackSupplier = DEFAULT_ITEMSTACK_SUPPLIER;
        this.tooltipSupplier = DEFAULT_WELEMENT_TOOLTIP_SUPPLIER;
        this.elementClass = this.getClass();
    }

    @Nonnull
    public Predicate<WInteraction> getForegroundCheck() {
        return this.foregroundCheck;
    }

    public final E setForegroundCheck(@Nonnull Predicate<WInteraction> foregroundCheck) {
        this.foregroundCheck = foregroundCheck;
        return (E)((WElement)this.elementClass.cast(this));
    }

    public final E setDefaultForegroundCheck() {
        this.foregroundCheck = this.default_check;
        return (E)((WElement)this.elementClass.cast(this));
    }

    public ITooltipSupplier getTooltipSupplier() {
        return this.tooltipSupplier;
    }

    @Nonnull
    public final E setTooltipSupplier(@Nonnull ITooltipSupplier tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return (E)((WElement)this.elementClass.cast(this));
    }

    public final E setDefaultTooltipSupplier() {
        this.tooltipSupplier = DEFAULT_WELEMENT_TOOLTIP_SUPPLIER;
        return (E)((WElement)this.elementClass.cast(this));
    }

    @Nonnull
    public Supplier<ItemStack> getItemStackSupplier() {
        return this.stackSupplier;
    }

    @Nonnull
    public final E setItemStackSupplier(@Nonnull Supplier<ItemStack> stackSupplier) {
        this.stackSupplier = stackSupplier;
        return (E)((WElement)this.elementClass.cast(this));
    }

    @Nonnull
    public final E setDefaultItemStackSupplier() {
        this.stackSupplier = DEFAULT_ITEMSTACK_SUPPLIER;
        return (E)((WElement)this.elementClass.cast(this));
    }

    @Nonnull
    public final List<String> getTooltip(@Nonnull WInteraction interaction) {
        return this.getTooltipSupplier().getTooltip(interaction, this.getItemStackSupplier());
    }

    public int getX() {
        return this.x;
    }

    public final void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public final void setY(int y) {
        this.y = y;
    }

    public final int getUsableX() {
        return this.wGuiContainer.getGuiLeft() + this.getX();
    }

    public final int getUsableY() {
        return this.wGuiContainer.getGuiTop() + this.getY();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public final int getWindowID() {
        return this.getWContainer().field_75152_c;
    }

    @Nonnull
    public final WGuiContainer<?> getWGuiContainer() {
        return this.wGuiContainer;
    }

    @Nonnull
    public final WContainer<?> getWContainer() {
        return this.wGuiContainer.getContainer();
    }

    @Nonnull
    public final EntityPlayer getEntityPlayer() {
        return this.wGuiContainer.getEntityPlayer();
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Nonnull
    public final Predicate<WInteraction> getInteractionCheck() {
        return this.interactionCheck;
    }

    @Nonnull
    public final E setInteractionCheck(@Nonnull Predicate<WInteraction> wInteractionPredicate) {
        this.interactionCheck = wInteractionPredicate;
        return (E)((WElement)this.elementClass.cast(this));
    }

    @Nonnull
    public final E setDefaultInteractionCheck() {
        this.interactionCheck = this.default_check;
        return (E)((WElement)this.elementClass.cast(this));
    }

    public final boolean canInteractWith(@Nonnull WInteraction wInteraction) {
        return this.interactionCheck.test(wInteraction);
    }

    public void interaction(@Nonnull WInteraction wInteraction) {
        if (wInteraction instanceof WKeyInteraction) {
            this.interaction((WKeyInteraction)wInteraction);
        } else if (wInteraction instanceof WMouseInteraction) {
            this.interaction((WMouseInteraction)wInteraction);
        }
    }

    public void interaction(@Nonnull WKeyInteraction wKeyInteraction) {
    }

    public void interaction(@Nonnull WMouseInteraction wMouseInteraction) {
    }

    public abstract void draw(@Nonnull WInteraction var1);

    public final void drawForeground(@Nonnull WInteraction interaction) {
        List<String> tooltip;
        if (this.foregroundCheck.test(interaction) && !(tooltip = this.getTooltip(interaction)).isEmpty()) {
            this.wGuiContainer.func_146283_a(tooltip, this.getTooltipX(interaction), this.getTooltipY(interaction));
        }
    }

    public int getTooltipX(@Nonnull WInteraction wInteraction) {
        return wInteraction.getMouseX() - this.wGuiContainer.getGuiLeft();
    }

    public int getTooltipY(@Nonnull WInteraction wInteraction) {
        return wInteraction.getMouseY() - this.wGuiContainer.getGuiTop();
    }

    public final SoundHandler getSoundHandler() {
        return Minecraft.func_71410_x().func_147118_V();
    }

    public final TextureManager getTextureManager() {
        return Minecraft.func_71410_x().func_110434_K();
    }

    public final FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    public final void playPressSound() {
        this.getSoundHandler().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    public final void playPressSound(@Nonnull ISound sound) {
        this.getSoundHandler().func_147682_a(sound);
    }
}

