/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.client.gui;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wanion.lib.client.gui.WElement;
import wanion.lib.client.gui.WGuiContainer;
import wanion.lib.client.gui.interaction.WInteraction;

@SideOnly(value=Side.CLIENT)
public class TextElement
extends WElement<TextElement> {
    public static final int DEFAULT_COLOR = 0x404040;
    public static final Supplier<Integer> DEFAULT_COLOR_SUPPLIER = () -> 0x404040;
    private final Supplier<String> textSupplier;
    private final FontRenderer fontRenderer;
    private final TextAnchor textAnchor;
    private Supplier<Integer> colorSupplier;

    public TextElement(@Nonnull Supplier<String> textSupplier, @Nonnull WGuiContainer<?> wGuiContainer, int x, int y) {
        this(textSupplier, wGuiContainer, x, y, TextAnchor.LEFT);
    }

    public TextElement(@Nonnull Supplier<String> textSupplier, @Nonnull WGuiContainer<?> wGuiContainer, int x, int y, @Nonnull TextAnchor textAnchor) {
        super(wGuiContainer, x, y);
        this.textSupplier = textSupplier;
        this.fontRenderer = this.getFontRenderer();
        this.textAnchor = textAnchor;
        this.colorSupplier = DEFAULT_COLOR_SUPPLIER;
        this.setForegroundCheck(interaction -> false);
    }

    public final int getColor() {
        return this.colorSupplier.get();
    }

    @Nonnull
    public TextElement setColorSupplier(@Nonnull Supplier<Integer> colorSupplier) {
        this.colorSupplier = colorSupplier;
        return this;
    }

    @Nonnull
    public TextElement setDefaultColorSupplier() {
        this.colorSupplier = DEFAULT_COLOR_SUPPLIER;
        return this;
    }

    @Override
    public int getX() {
        return super.getX() + this.textAnchor.getX(this, this.textSupplier.get());
    }

    @Override
    public int getWidth() {
        return this.fontRenderer.func_78256_a(this.textSupplier.get());
    }

    @Override
    public int getHeight() {
        return this.fontRenderer.field_78288_b;
    }

    @Override
    public void draw(@Nonnull WInteraction wInteraction) {
        this.fontRenderer.func_78276_b(this.textSupplier.get(), this.getUsableX(), this.getUsableY(), this.getColor());
    }

    public static enum TextAnchor {
        LEFT,
        MIDDLE,
        RIGHT;


        public int getX(@Nonnull TextElement textElement, @Nonnull String text) {
            switch (textElement.textAnchor) {
                case MIDDLE: {
                    return -(textElement.fontRenderer.func_78256_a(text) / 2);
                }
                case RIGHT: {
                    return -textElement.fontRenderer.func_78256_a(text);
                }
            }
            return 0;
        }
    }
}

