/*
 * Decompiled with CFR 0.152.
 */
package com.kashdeya.tinyprogressions.blocks.oredoubler;

import com.kashdeya.tinyprogressions.main.TinyProgressions;
import com.kashdeya.tinyprogressions.tiles.TileEntityOreDoubler;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class IronFurnaceBlock
extends BlockHorizontal
implements ITileEntityProvider {
    public static final PropertyBool ISBURNING = PropertyBool.func_177716_a((String)"isburning");
    private int cookSpeedInTicks = 100;

    public IronFurnaceBlock(int cookSpeedInTicksIn) {
        super(Material.field_151576_e);
        this.func_149711_c(1.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149752_b(1000.0f);
        this.func_149647_a(TinyProgressions.tabTP);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149663_c("iron_furnace_block");
        this.cookSpeedInTicks = cookSpeedInTicksIn;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityOreDoubler().setCookSpeed(this.cookSpeedInTicks);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        playerIn.openGui((Object)TinyProgressions.instance, 1, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (IronFurnaceBlock.isBurning(stateIn)) {
            EnumFacing enumfacing = (EnumFacing)stateIn.func_177229_b((IProperty)field_185512_D);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0;
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d3 = 0.52;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            if (rand.nextDouble() < 0.1) {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            switch (enumfacing) {
                case WEST: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 - 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 - 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case EAST: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case NORTH: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 - 0.52, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 - 0.52, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case SOUTH: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 + 0.52, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 + 0.52, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityOreDoubler) {
            ((TileEntityOreDoubler)te).inputInventory.dropInventory(worldIn, pos);
            ((TileEntityOreDoubler)te).outputInventory.dropInventory(worldIn, pos);
            ((TileEntityOreDoubler)te).fuelInventory.dropInventory(worldIn, pos);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public static EnumFacing getFacing(IBlockState blockStateContainer) {
        return (EnumFacing)blockStateContainer.func_177229_b((IProperty)field_185512_D);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        if (!worldIn.field_72995_K) {
            worldIn.func_184138_a(pos, worldIn.func_180495_p(pos), worldIn.func_180495_p(pos), 2);
        }
    }

    public static boolean isBurning(IBlockState blockStateContainer) {
        return (Boolean)blockStateContainer.func_177229_b((IProperty)ISBURNING);
    }

    public static void setBurning(World worldIn, BlockPos pos, boolean isBurningIn) {
        worldIn.func_180500_c(EnumSkyBlock.BLOCK, pos);
        worldIn.func_180501_a(pos, worldIn.func_180495_p(pos).func_177226_a((IProperty)field_185512_D, (Comparable)IronFurnaceBlock.getFacing(worldIn.func_180495_p(pos))).func_177226_a((IProperty)ISBURNING, (Comparable)Boolean.valueOf(isBurningIn)), 3);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (IronFurnaceBlock.isBurning(state)) {
            return 15;
        }
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a((IProperty)ISBURNING, (Comparable)Boolean.valueOf(meta >> 2 == 1));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b();
        return i |= ((Boolean)state.func_177229_b((IProperty)ISBURNING) != false ? 1 : 0) << 2;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D, ISBURNING});
    }
}

