/*
 * Decompiled with CFR 0.152.
 */
package com.rumaruka.thaumicbases.common.item;

import com.rumaruka.thaumicbases.api.ITobacco;
import com.rumaruka.thaumicbases.common.item.TBTobacco;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSmokingPipe
extends Item {
    public boolean isSilverwood;

    public ItemSmokingPipe(boolean silverwood) {
        this.isSilverwood = silverwood;
        this.func_77664_n();
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                return !(entityIn.func_184607_cu().func_77973_b() instanceof ItemSmokingPipe) ? 0.0f : (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public ItemStack findTobacco(EntityPlayer smoker) {
        if (this.isTobacco(smoker.func_184586_b(EnumHand.OFF_HAND))) {
            return smoker.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isTobacco(smoker.func_184586_b(EnumHand.MAIN_HAND))) {
            return smoker.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < smoker.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = smoker.field_71071_by.func_70301_a(i);
            if (!this.isTobacco(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    protected boolean isTobacco(ItemStack stack) {
        return stack.func_77973_b() instanceof TBTobacco;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        boolean flag;
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        boolean bl = flag = !this.findTobacco(playerIn).func_190926_b();
        if (!flag) {
            return flag ? new ActionResult(EnumActionResult.PASS, (Object)itemstack) : new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 64;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        Vec3d look = Vec3d.func_189984_a((Vec2f)new Vec2f(player.field_70125_A, player.field_70177_z));
        double x = player.field_70165_t + look.field_72450_a / 5.0;
        double y = player.field_70163_u + (double)player.func_70047_e() + look.field_72448_b / 5.0;
        double z = player.field_70161_v + look.field_72449_c / 5.0;
        if (count < 32) {
            player.field_70170_p.func_175688_a(this.isSilverwood ? EnumParticleTypes.EXPLOSION_NORMAL : EnumParticleTypes.SMOKE_NORMAL, x, y, z, look.field_72450_a / 10.0, look.field_72448_b / 10.0, look.field_72449_c / 10.0, new int[0]);
        }
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack tobacco = this.findTobacco(player);
        if (tobacco.func_190926_b()) {
            return EnumActionResult.FAIL;
        }
        ITobacco t = (ITobacco)tobacco.func_77973_b();
        t.performTobaccoEffect(player, tobacco, this.isSilverwood);
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stk = player.field_71071_by.func_70301_a(i);
            if (stk == ItemStack.field_190927_a || new ItemStack(stk.func_77973_b()).equals(ItemStack.field_190927_a) || !(stk.func_77973_b() instanceof ITobacco)) continue;
            this.func_77626_a(stk);
            player.field_71071_by.func_70298_a(i, 1);
            break;
        }
        Vec3d look = Vec3d.func_189984_a((Vec2f)new Vec2f(player.field_70125_A, player.field_70177_z));
        for (int i = 0; i < 100; ++i) {
            double x = player.field_70165_t + look.field_72450_a / 5.0;
            double y = player.field_70163_u + (double)player.func_70047_e() + look.field_72448_b / 5.0;
            double z = player.field_70161_v + look.field_72449_c / 5.0;
            player.field_70170_p.func_175688_a(this.isSilverwood ? EnumParticleTypes.EXPLOSION_NORMAL : EnumParticleTypes.SMOKE_NORMAL, x, y, z, look.field_72450_a / 10.0, look.field_72448_b / 10.0, look.field_72449_c / 10.0, new int[0]);
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }
}

