/*
 * Decompiled with CFR 0.152.
 */
package com.rumaruka.thaumicbases.common.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.crafting.IInfusionStabiliser;

public abstract class BlockTBSlab
extends Block
implements IInfusionStabiliser {
    public static final PropertyEnum<EnumBlockHalf> HALF = PropertyEnum.func_177709_a((String)"half", EnumBlockHalf.class);
    protected static final AxisAlignedBB AABB_BOTTOM_HALF = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_TOP_HALF = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
    final boolean isFullBlock;
    public boolean isAStabiliser;

    public BlockTBSlab(Material materialIn, boolean b) {
        super(materialIn);
        this.isFullBlock = b;
    }

    public boolean isFullBlock() {
        return this.isFullBlock;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this.isDouble()) {
            return field_185505_j;
        }
        return state.func_177229_b(HALF) == EnumBlockHalf.TOP ? AABB_TOP_HALF : AABB_BOTTOM_HALF;
    }

    public boolean func_185481_k(IBlockState state) {
        return ((BlockTBSlab)state.func_177230_c()).isDouble() || state.func_177229_b(HALF) == EnumBlockHalf.TOP;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (((BlockTBSlab)state.func_177230_c()).isDouble()) {
            return BlockFaceShape.SOLID;
        }
        if (face == EnumFacing.UP && state.func_177229_b(HALF) == EnumBlockHalf.TOP) {
            return BlockFaceShape.SOLID;
        }
        return face == EnumFacing.DOWN && state.func_177229_b(HALF) == EnumBlockHalf.BOTTOM ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return this.isFullBlock;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (ForgeModContainer.disableStairSlabCulling) {
            return super.doesSideBlockRendering(state, world, pos, face);
        }
        if (state.func_185914_p()) {
            return true;
        }
        EnumBlockHalf side = (EnumBlockHalf)((Object)state.func_177229_b(HALF));
        return side == EnumBlockHalf.TOP && face == EnumFacing.UP || side == EnumBlockHalf.BOTTOM && face == EnumFacing.DOWN;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.BOTTOM));
        if (this.isDouble()) {
            return iblockstate;
        }
        return facing != EnumFacing.DOWN && (facing == EnumFacing.UP || (double)hitY <= 0.5) ? iblockstate : iblockstate.func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.TOP));
    }

    public int func_149745_a(Random random) {
        return this.isDouble() ? 2 : 1;
    }

    public boolean func_149686_d(IBlockState state) {
        return this.isDouble();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (this.isDouble()) {
            return super.func_176225_a(blockState, blockAccess, pos, side);
        }
        if (side != EnumFacing.UP && side != EnumFacing.DOWN && !super.func_176225_a(blockState, blockAccess, pos, side)) {
            return false;
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    protected static boolean isHalfSlab(IBlockState state) {
        Block block = state.func_177230_c();
        return block == Blocks.field_150333_U || block == Blocks.field_150376_bx || block == Blocks.field_180389_cP || block == Blocks.field_185771_cX;
    }

    public boolean canStabaliseInfusion(World world, BlockPos blockPos) {
        return this.isAStabiliser;
    }

    public abstract String getUnlocalizedName(int var1);

    public abstract boolean isDouble();

    public abstract IProperty<?> getVariantProperty();

    public abstract Comparable<?> getTypeForItem(ItemStack var1);

    public static enum EnumBlockHalf implements IStringSerializable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private EnumBlockHalf(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

