/*
 * Decompiled with CFR 0.152.
 */
package com.rumaruka.thaumicbases.common.block;

import com.rumaruka.thaumicbases.init.TBBlocks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTBLeaves
extends Block
implements IShearable {
    int leafType;
    public static final PropertyEnum<LeafGrowth> GROWTH = PropertyEnum.func_177709_a((String)"growth", LeafGrowth.class);

    public BlockTBLeaves(int type) {
        super(Material.field_151584_j);
        this.leafType = type;
        this.func_149675_a(true);
        this.func_149711_c(0.2f);
        this.func_149713_g(1);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(GROWTH, (Comparable)((Object)LeafGrowth.FRESH)));
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 60;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 30;
    }

    public boolean func_149662_c(IBlockState state) {
        return Blocks.field_150362_t.func_149662_c(state);
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177230_c() == TBBlocks.goldenleaves ? MapColor.field_151674_s : super.func_180659_g(state, worldIn, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this));
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack((Block)this);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        LeafGrowth leaf;
        int randInt;
        int blocks = 0;
        for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            EnumFacing dir = EnumFacing.field_82609_l[i];
            IBlockState neighbour = world.func_180495_p(pos.func_177972_a(dir));
            Block block = neighbour.func_177230_c();
            if (block.isAir(neighbour, (IBlockAccess)world, pos)) continue;
            ++blocks;
        }
        if (blocks != 6 && (randInt = this.leafType == 3 ? rand.nextInt(10) : (this.leafType < 2 ? rand.nextInt(8) : rand.nextInt(9))) <= 2 && (leaf = (LeafGrowth)((Object)state.func_177229_b(GROWTH))).canGrow()) {
            world.func_175656_a(pos, state.func_177231_a(GROWTH));
        }
    }

    public void dropApple(World worldIn, BlockPos pos, IBlockState state, int chance) {
        if (this.leafType == 0 && worldIn.field_73012_v.nextInt(chance) < 60) {
            BlockTBLeaves.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(Items.field_151153_ao, 1));
        }
    }

    public void dropMagmacream(World worldIn, BlockPos pos, IBlockState state, int chance) {
        if (this.leafType == 1 && worldIn.field_73012_v.nextInt(chance) < 60) {
            BlockTBLeaves.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(Items.field_151064_bs, 1));
        }
    }

    public void dropEnderpearl(World world, BlockPos pos, IBlockState state, int chance) {
        if (this.leafType == 2 && world.field_73012_v.nextInt(chance) < 60) {
            BlockTBLeaves.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(Items.field_151079_bi, 1));
        }
    }

    public int func_149738_a(World world) {
        return 8;
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, int metadata, EnumFacing face) {
        return 150;
    }

    public void beginLeavesDecay(IBlockState state, World world, BlockPos pos) {
    }

    public boolean isLeaves(IBlockState state, IBlockAccess world, BlockPos posz) {
        return true;
    }

    public boolean func_176225_a(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean isShearable(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        switch (this.leafType) {
            case 0: {
                ret.add(new ItemStack(TBBlocks.goldenleaves, 1, 0));
                break;
            }
            case 1: {
                ret.add(new ItemStack(TBBlocks.netherleaves, 1, 0));
                break;
            }
            case 2: {
                ret.add(new ItemStack(TBBlocks.enderleaves, 1, 0));
            }
        }
        return ret;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public LeafGrowth getVariant(int metadata) {
        for (LeafGrowth colour : LeafGrowth.values()) {
            if (colour.meta != metadata) continue;
            return colour;
        }
        return LeafGrowth.FRESH;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(GROWTH, (Comparable)((Object)this.getVariant(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((LeafGrowth)((Object)state.func_177229_b(GROWTH))).getMeta();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{GROWTH});
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return Minecraft.func_71375_t() ? BlockRenderLayer.CUTOUT_MIPPED : BlockRenderLayer.SOLID;
    }

    public boolean isVisuallyOpaque() {
        return false;
    }

    public int getSaplingDropChance(IBlockState state) {
        return this.leafType == 0 ? 50 : 30;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        int chance = this.getSaplingDropChance(state);
        if (fortune > 0 && (chance -= 2 << fortune) < 10) {
            chance = 10;
        }
        if (this.leafType == 0 && rand.nextInt(chance) == 0) {
            ret.add(new ItemStack(TBBlocks.goldensapling));
        }
        if (this.leafType == 1 && rand.nextInt(chance) == 0) {
            ret.add(new ItemStack(TBBlocks.nethersapling));
        }
        if (this.leafType == 2 && rand.nextInt(chance) == 0) {
            ret.add(new ItemStack(TBBlocks.endersapling));
        }
        chance = 200;
        if (fortune > 0 && (chance -= 10 << fortune) < 40) {
            chance = 40;
        }
        this.captureDrops(true);
        if (world instanceof World) {
            this.dropApple((World)world, pos, state, chance);
        }
        this.dropEnderpearl((World)world, pos, state, chance);
        this.dropMagmacream((World)world, pos, state, chance);
        ret.addAll((Collection<ItemStack>)this.captureDrops(false));
        return ret;
    }

    public static enum LeafGrowth implements IStringSerializable
    {
        FRESH(0),
        GROWING(1),
        READY(2),
        MATURED(3);

        private int meta;

        private LeafGrowth(int meta) {
            this.meta = meta;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public boolean canGrow() {
            return this != MATURED;
        }

        public int getMeta() {
            return this.meta;
        }
    }
}

