/*
 * Decompiled with CFR 0.152.
 */
package com.rumaruka.thaumicbases.common.block;

import com.rumaruka.thaumicbases.core.TBCore;
import com.rumaruka.thaumicbases.init.TBItems;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTBBush
extends Block
implements IPlantable,
IGrowable {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)3);
    private ItemStack itemDrop = new ItemStack(TBItems.briar_seedbag);
    public static final AxisAlignedBB SMALL_BUSH_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
    public static final AxisAlignedBB MEDIUM_BUSH_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.75, 0.875);
    public static final AxisAlignedBB FULL_BUSH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    public BlockTBBush() {
        super(Material.field_151584_j);
        this.func_149675_a(true);
        this.func_149711_c(0.3f);
        this.func_149672_a(SoundType.field_185850_c);
    }

    public boolean isMaxAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE) >= 3;
    }

    public void setItemDrop(ItemStack itemIn) {
        this.itemDrop = itemIn;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        if (age == 0) {
            return SMALL_BUSH_AABB;
        }
        if (age == 1) {
            return MEDIUM_BUSH_AABB;
        }
        if (age == 2) {
            return FULL_BUSH_AABB;
        }
        if (age == 3) {
            return FULL_BUSH_AABB;
        }
        return FULL_BUSH_AABB;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return !this.isMaxAge(state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        int meta = (Integer)state.func_177229_b((IProperty)AGE);
        if (meta < 2) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta + 1)));
            return true;
        }
        return false;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return TBCore.proxy.fancyGraphicsEnable() ? BlockRenderLayer.CUTOUT_MIPPED : BlockRenderLayer.SOLID;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return !TBCore.proxy.fancyGraphicsEnable() && blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() == this ? false : super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public boolean isTopBlock(int meta) {
        return meta > 3;
    }

    public void func_180650_b(World w, BlockPos pos, IBlockState state, Random rnd) {
        super.func_180650_b(w, pos, state, rnd);
        if (w.func_180495_p(pos).func_177230_c() == this) {
            int meta = (Integer)w.func_180495_p(pos).func_177229_b((IProperty)AGE);
            if (this.isTopBlock(meta)) {
                if (meta - 3 < 3 && w.field_73012_v.nextInt(4) == 0) {
                    w.func_175656_a(pos, this.func_176203_a(meta + 1));
                }
            } else if (meta < 3 && w.field_73012_v.nextInt(4) == 0) {
                w.func_175656_a(pos, this.func_176203_a(meta + 1));
            }
        }
    }

    public boolean func_149686_d(IBlockState state) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        if (age == 0) {
            return false;
        }
        if (age == 1) {
            return false;
        }
        if (age == 2) {
            return true;
        }
        return age == 3;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        if (worldIn.field_72995_K) {
            return;
        }
        int age = (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)AGE);
        if (age == 3) {
            worldIn.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(2)), 2);
            ItemStack itemDrop = new ItemStack(TBItems.briar_seedbag, 1);
            EntityItem entityitem = new EntityItem(worldIn, playerIn.field_70165_t, playerIn.field_70163_u - 1.0, playerIn.field_70161_v, itemDrop);
            worldIn.func_72838_d((Entity)entityitem);
            if (!(playerIn instanceof FakePlayer)) {
                entityitem.func_70100_b_(playerIn);
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        if (age == 3) {
            if (worldIn.field_72995_K) {
                return true;
            }
            worldIn.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(2)), 2);
            ItemStack itemDrop = new ItemStack(TBItems.briar_seedbag, 1);
            EntityItem entityitem = new EntityItem(worldIn, playerIn.field_70165_t, playerIn.field_70163_u - 1.0, playerIn.field_70161_v, itemDrop);
            worldIn.func_72838_d((Entity)entityitem);
            if (!(playerIn instanceof FakePlayer)) {
                entityitem.func_70100_b_(playerIn);
            }
            return true;
        }
        return false;
    }
}

