/*
 * Decompiled with CFR 0.152.
 */
package com.rumaruka.thaumicbases.common.block;

import com.rumaruka.thaumicbases.init.TBItems;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class BlockRedlonStem
extends BlockBush
implements IGrowable {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);
    public static final PropertyDirection FACING = BlockTorch.field_176596_a;
    private final Block crop;
    protected static final AxisAlignedBB[] STEM_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.125, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.25, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.375, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.5, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.625, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.75, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.875, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625)};

    public BlockRedlonStem(Block crop) {
        this.crop = crop;
        this.func_149675_a(true);
        this.func_149647_a(null);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return STEM_AABB[(Integer)state.func_177229_b((IProperty)AGE)];
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        int i = (Integer)state.func_177229_b((IProperty)AGE);
        state = state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP);
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c() != this.crop || i != 7) continue;
            state = state.func_177226_a((IProperty)FACING, (Comparable)enumfacing);
            break;
        }
        return state;
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        worldIn.func_175688_a(EnumParticleTypes.REDSTONE, (double)pos.func_177958_n() + rand.nextDouble(), (double)pos.func_177956_o() + rand.nextDouble(), (double)pos.func_177952_p() + rand.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
    }

    protected boolean func_185514_i(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150458_ak;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        if (!worldIn.func_175697_a(pos, 1)) {
            return;
        }
        if (worldIn.func_175671_l(pos.func_177984_a()) >= 9) {
            float f = BlockRedlonStem.getGrowthChance((Block)this, worldIn, pos);
            if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (rand.nextInt((int)(25.0f / f) + 1) == 0 ? 1 : 0) != 0)) {
                int i = (Integer)state.func_177229_b((IProperty)AGE);
                if (i < 7) {
                    IBlockState newState = state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(i + 1));
                    worldIn.func_180501_a(pos, newState, 2);
                } else {
                    for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                        if (worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c() != this.crop) continue;
                        return;
                    }
                    pos = pos.func_177972_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(rand));
                    IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
                    Block block = soil.func_177230_c();
                    if (worldIn.func_175623_d(pos) && (block.canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this) || block == Blocks.field_150346_d || block == Blocks.field_150349_c)) {
                        worldIn.func_175656_a(pos, this.crop.func_176223_P());
                    }
                }
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
            }
        }
    }

    public void growStem(World worldIn, BlockPos pos, IBlockState state) {
        int i = (Integer)state.func_177229_b((IProperty)AGE) + MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)2, (int)5);
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(Math.min(7, i))), 2);
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        super.func_180653_a(worldIn, pos, state, chance, fortune);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Item item = this.getSeedItem();
        if (item != null) {
            int i = (Integer)state.func_177229_b((IProperty)AGE);
            for (int j = 0; j < 3; ++j) {
                if (RANDOM.nextInt(15) > i) continue;
                drops.add((Object)new ItemStack(item));
            }
        }
    }

    @Nullable
    protected Item getSeedItem() {
        if (this.crop == Blocks.field_150451_bX) {
            return TBItems.redlonseed;
        }
        return null;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        Item item = this.getSeedItem();
        return item == null ? ItemStack.field_190927_a : new ItemStack(item);
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((IProperty)AGE) != 7;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        this.growStem(worldIn, pos, state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, FACING});
    }

    protected static float getGrowthChance(Block blockIn, World worldIn, BlockPos pos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = pos.func_177977_b();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                IBlockState iblockstate = worldIn.func_180495_p(blockpos.func_177982_a(i, 0, j));
                if (iblockstate.func_177230_c().canSustainPlant(iblockstate, (IBlockAccess)worldIn, blockpos.func_177982_a(i, 0, j), EnumFacing.UP, (IPlantable)blockIn)) {
                    f1 = 1.0f;
                    if (iblockstate.func_177230_c().isFertile(worldIn, blockpos.func_177982_a(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pos.func_177978_c();
        BlockPos blockpos2 = pos.func_177968_d();
        BlockPos blockpos3 = pos.func_177976_e();
        BlockPos blockpos4 = pos.func_177974_f();
        boolean flag = blockIn == worldIn.func_180495_p(blockpos3).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4).func_177230_c();
        boolean bl = flag1 = blockIn == worldIn.func_180495_p(blockpos1).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos2).func_177230_c();
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = blockIn == worldIn.func_180495_p(blockpos3.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4.func_177968_d()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos3.func_177968_d()).func_177230_c();
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }
}

