/*
 * Decompiled with CFR 0.152.
 */
package com.rumaruka.thaumicbases.common.block;

import com.rumaruka.thaumicbases.init.TBItems;
import com.rumaruka.thaumicbases.utils.TBConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class BlockPlax
extends BlockBush
implements IGrowable {
    public int growthStages;
    public int growthDelay;
    public boolean requiresFarmland;
    public PropertyInteger AGE;
    public ItemStack dropItem;
    public ItemStack dropSeed;

    public BlockPlax(int stages, int delay, boolean isCrop) {
        this.growthStages = stages;
        this.growthDelay = delay;
        this.requiresFarmland = isCrop;
        this.func_149675_a(true);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149649_H();
    }

    protected BlockStateContainer func_180661_e() {
        if (this.AGE == null) {
            this.AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);
        }
        return new BlockStateContainer((Block)this, new IProperty[]{this.AGE});
    }

    public int getGrowthStages() {
        return this.growthStages;
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.AGE);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.AGE, (Comparable)Integer.valueOf(Math.min(this.growthStages, meta)));
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        float f;
        int i;
        super.func_180650_b(worldIn, pos, state, rand);
        if (!worldIn.func_175697_a(pos, 1)) {
            return;
        }
        if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && (i = ((Integer)state.func_177229_b((IProperty)this.AGE)).intValue()) < this.getGrowthStages() && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (rand.nextInt((int)(25.0f / (f = BlockPlax.getGrowthChance((Block)this, worldIn, pos))) + 1) == 0 ? 1 : 0) != 0)) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)this.AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
        }
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        int j;
        int i = this.getAge(state) + this.getBonemealAgeIncrease(worldIn);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        worldIn.func_180501_a(pos, this.withAge(i), 2);
    }

    protected int getBonemealAgeIncrease(World worldIn) {
        return MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)2, (int)5);
    }

    public int getMaxAge() {
        return this.growthStages;
    }

    protected int getAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty());
    }

    protected PropertyInteger getAgeProperty() {
        return this.AGE;
    }

    public IBlockState withAge(int age) {
        return this.func_176223_P().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public List<ItemStack> getDrops(IBlockAccess w, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (w instanceof World) {
            World world = (World)World.class.cast(w);
            int metadata = (Integer)state.func_177229_b((IProperty)this.AGE);
            if (metadata >= this.growthStages - 1) {
                for (int i = 0; i < 1; ++i) {
                    if (world.field_73012_v.nextInt(this.growthStages) > metadata || this.dropSeed == ItemStack.field_190927_a) continue;
                    for (int j = 0; j < TBConfig.firstDropItemInSeeeds + fortune; ++j) {
                        if (!world.field_73012_v.nextBoolean()) continue;
                        ret.add(new ItemStack(Items.field_151007_F, 3));
                        ret.add(new ItemStack(TBItems.plaxseed, 1));
                    }
                }
            }
        }
        return ret;
    }

    protected static float getGrowthChance(Block blockIn, World worldIn, BlockPos pos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = pos.func_177977_b();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                IBlockState iblockstate = worldIn.func_180495_p(blockpos.func_177982_a(i, 0, j));
                if (iblockstate.func_177230_c().canSustainPlant(iblockstate, (IBlockAccess)worldIn, blockpos.func_177982_a(i, 0, j), EnumFacing.UP, (IPlantable)blockIn)) {
                    f1 = 1.0f;
                    if (iblockstate.func_177230_c().isFertile(worldIn, blockpos.func_177982_a(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pos.func_177978_c();
        BlockPos blockpos2 = pos.func_177968_d();
        BlockPos blockpos3 = pos.func_177976_e();
        BlockPos blockpos4 = pos.func_177974_f();
        boolean flag = blockIn == worldIn.func_180495_p(blockpos3).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4).func_177230_c();
        boolean bl = flag1 = blockIn == worldIn.func_180495_p(blockpos1).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos2).func_177230_c();
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = blockIn == worldIn.func_180495_p(blockpos3.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4.func_177968_d()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos3.func_177968_d()).func_177230_c();
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }
}

