/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.ae2wtlib.api.client.render;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.pipeline.LightUtil;
import p455w0rd.ae2wtlib.api.ICustomWirelessTerminalItem;
import p455w0rdslib.api.client.ICustomItemRenderer;
import p455w0rdslib.api.client.IModelHolder;
import p455w0rdslib.api.client.ItemLayerWrapper;

public class WTItemRenderer
extends TileEntityItemStackRenderer
implements ICustomItemRenderer {
    public ItemLayerWrapper model;
    public static ItemCameraTransforms.TransformType transformType;
    private static final Map<Item, ICustomItemRenderer> CACHE;

    private WTItemRenderer(@Nonnull Item item) {
        WTItemRenderer.registerRenderer(item, this);
    }

    private static void registerRenderer(Item item, ICustomItemRenderer instance) {
        CACHE.put(item, instance);
    }

    public static ICustomItemRenderer getRendererForItem(Item item) {
        if (!CACHE.containsKey(item)) {
            new WTItemRenderer(item);
        }
        return CACHE.get(item);
    }

    public void func_192838_a(ItemStack stack, float partialTicks) {
        if (stack == null) {
            return;
        }
        if (this.model == null) {
            IBakedModel baseModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
            if (baseModel == null) {
                return;
            }
            ItemLayerWrapper wrapper = new ItemLayerWrapper(baseModel).setRenderer((ICustomItemRenderer)this);
            Item item = stack.func_77973_b();
            if (item instanceof IModelHolder) {
                ((IModelHolder)item).setWrappedModel(wrapper);
            }
            this.model = wrapper;
        }
        float pbx = OpenGlHelper.lastBrightnessX;
        float pby = OpenGlHelper.lastBrightnessY;
        if (stack.func_77973_b().func_77636_d(stack)) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        }
        RenderModel.render((IBakedModel)this.model, stack);
        if (stack.func_77962_s()) {
            GlintEffectRenderer.apply((IBakedModel)this.model, ((ICustomWirelessTerminalItem)stack.func_77973_b()).getColor());
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)pbx, (float)pby);
        }
    }

    public ItemCameraTransforms.TransformType getTransformType() {
        return transformType;
    }

    public void setTransformType(ItemCameraTransforms.TransformType type) {
        transformType = type;
    }

    static {
        CACHE = new HashMap<Item, ICustomItemRenderer>();
    }

    public static class GlintEffectRenderer {
        public static void apply(IBakedModel model, int color) {
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179143_c((int)514);
            GlStateManager.func_179140_f();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("minecraft", "textures/misc/enchanted_item_glint.png"));
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
            float f = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f / 8.0f;
            GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            RenderModel.render(model, color);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179145_e();
            GlStateManager.func_179143_c((int)515);
            GlStateManager.func_179132_a((boolean)true);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        }
    }

    public static class RenderModel {
        public static void render(IBakedModel model, @Nonnull ItemStack stack) {
            RenderModel.render(model, -1, stack);
        }

        public static void render(IBakedModel model, int color) {
            RenderModel.render(model, color, ItemStack.field_190927_a);
        }

        public static void render(IBakedModel model, int color, @Nonnull ItemStack stack) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexbuffer = tessellator.func_178180_c();
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            for (EnumFacing enumfacing : EnumFacing.values()) {
                RenderModel.renderQuads(vertexbuffer, model.func_188616_a((IBlockState)null, enumfacing, 0L), color, stack);
            }
            RenderModel.renderQuads(vertexbuffer, model.func_188616_a((IBlockState)null, (EnumFacing)null, 0L), color, stack);
            tessellator.func_78381_a();
        }

        public static void renderQuads(BufferBuilder renderer, List<BakedQuad> quads, int color, ItemStack stack) {
            boolean flag = color == -1 && !stack.func_190926_b();
            int j = quads.size();
            for (int i = 0; i < j; ++i) {
                BakedQuad bakedquad = quads.get(i);
                int k = color;
                if (flag && bakedquad.func_178212_b()) {
                    ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
                    k = itemColors.func_186728_a(stack, bakedquad.func_178211_c());
                    if (EntityRenderer.field_78517_a) {
                        k = TextureUtil.func_177054_c((int)k);
                    }
                    k |= 0xFF000000;
                }
                LightUtil.renderQuadColor((BufferBuilder)renderer, (BakedQuad)bakedquad, (int)k);
            }
        }
    }
}

