/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters.util;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import me.towdium.jecharacters.core.JechCore;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class Profiler {
    private static final JarContainer[] EMPTY_JC = new JarContainer[0];
    private static final String[] EMPTY_STR = new String[0];

    public static Report run() {
        File modDirectory = new File("mods");
        JarContainer[] jcs = Profiler.scanDirectory(modDirectory).toArray(EMPTY_JC);
        Report r = new Report();
        r.jars = jcs;
        return r;
    }

    private static ArrayList<JarContainer> scanDirectory(File f) {
        File[] files = f.listFiles();
        ArrayList<JarContainer> jcs = new ArrayList<JarContainer>();
        Consumer<JarContainer> callback = jcs::add;
        if (files != null) {
            for (File file : files) {
                if (file.isFile() && file.getName().endsWith(".jar")) {
                    try (ZipFile mod = new ZipFile(file);){
                        Profiler.scanJar(mod, callback);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!file.isDirectory()) continue;
                jcs.addAll(Profiler.scanDirectory(file));
            }
        }
        return jcs;
    }

    private static void scanJar(ZipFile f, Consumer<JarContainer> cbkJar) {
        ArrayList methodsString = new ArrayList();
        ArrayList methodsRegExp = new ArrayList();
        ArrayList methodsSuffix = new ArrayList();
        ArrayList methodsStrsKt = new ArrayList();
        JarContainer ret = new JarContainer();
        f.stream().forEach(entry -> {
            if (entry.getName().endsWith(".class")) {
                try (InputStream is = f.getInputStream((ZipEntry)entry);){
                    long size = entry.getSize() + 4L;
                    if (size > Integer.MAX_VALUE) {
                        JechCore.LOG.info("Class file " + entry.getName() + " in jar file " + f.getName() + " is too large, skip.");
                    } else {
                        Profiler.scanClass(is, methodsString::add, methodsRegExp::add, methodsSuffix::add, methodsStrsKt::add);
                    }
                }
                catch (IOException e) {
                    JechCore.LOG.info("Fail to read file " + entry.getName() + " in jar file " + f.getName() + ", skip.");
                }
            } else if (entry.getName().equals("mcmod.info")) {
                Gson gson = new Gson();
                try (InputStream is = f.getInputStream((ZipEntry)entry);){
                    try {
                        ret.mods = (ModContainer[])gson.fromJson((Reader)new InputStreamReader(is), ModContainer[].class);
                    }
                    catch (Exception e) {
                        ret.mods = new ModContainer[]{(ModContainer)gson.fromJson((Reader)new InputStreamReader(is), ModContainer.class)};
                    }
                }
                catch (Exception e) {
                    JechCore.LOG.info("Fail to read mod info in jar file " + f.getName() + ", skip.");
                }
            }
        });
        if (!(methodsString.isEmpty() && methodsRegExp.isEmpty() && methodsSuffix.isEmpty() && methodsStrsKt.isEmpty())) {
            ret.methodsString = methodsString.toArray(EMPTY_STR);
            ret.methodsRegExp = methodsRegExp.toArray(EMPTY_STR);
            ret.methodsSuffix = methodsSuffix.toArray(EMPTY_STR);
            ret.methodsStrsKt = methodsStrsKt.toArray(EMPTY_STR);
            cbkJar.accept(ret);
        }
    }

    private static void scanClass(InputStream is, Consumer<String> string, Consumer<String> regexp, Consumer<String> suffix, Consumer<String> strskt) throws IOException {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(is);
        try {
            classReader.accept((ClassVisitor)classNode, 0);
        }
        catch (Exception e) {
            if (classNode.name != null) {
                JechCore.LOG.info("File decoding of class " + classNode.name + " failed. Try to continue.");
            }
            throw new IOException(e);
        }
        classNode.methods.forEach(methodNode -> {
            for (AbstractInsnNode node : methodNode.instructions) {
                TypeInsnNode tNode;
                if (node instanceof MethodInsnNode) {
                    MethodInsnNode mNode = (MethodInsnNode)node;
                    if (mNode.getOpcode() == 182 && mNode.owner.equals("java/lang/String") && mNode.name.equals("contains") && mNode.desc.equals("(Ljava/lang/CharSequence;)Z")) {
                        string.accept((classNode.name + ":" + methodNode.name + ":" + methodNode.desc).replace('/', '.'));
                        break;
                    }
                    if (mNode.getOpcode() == 182 && mNode.owner.equals("java/lang/String") && mNode.name.equals("matches") && mNode.desc.equals("(Ljava/lang/String;)Z")) {
                        regexp.accept((classNode.name + ":" + methodNode.name + ":" + methodNode.desc).replace('/', '.'));
                        break;
                    }
                    if (mNode.getOpcode() == 182 && mNode.owner.equals("java/util/regex/Pattern") && mNode.name.equals("matcher") && mNode.desc.equals("(Ljava/lang/CharSequence;)Ljava/util/regex/Matcher;")) {
                        regexp.accept((classNode.name + ":" + methodNode.name + ":" + methodNode.desc).replace('/', '.'));
                        break;
                    }
                    if (mNode.getOpcode() != 184 || !mNode.owner.equals("kotlin/text/StringsKt") || !mNode.name.equals("contains") || !mNode.desc.equals("(Ljava/lang/CharSequence;Ljava/lang/CharSequence;Z)Z")) continue;
                    strskt.accept((classNode.name + ":" + methodNode.name + ":" + methodNode.desc).replace('/', '.'));
                    break;
                }
                if (!(node instanceof TypeInsnNode) || ((tNode = (TypeInsnNode)node).getOpcode() != 187 || !tNode.desc.equals("net/minecraft/client/util/SuffixArray") && !tNode.desc.equals("cgx")) && !tNode.desc.equals("cgz")) continue;
                suffix.accept((classNode.name + ":" + methodNode.name + ":" + methodNode.desc).replace('/', '.'));
                break;
            }
        });
    }

    private static class ModContainer {
        String modid;
        String name;
        String version;
        String mcversion;
        String url;
        String[] authorList;

        private ModContainer() {
        }
    }

    private static class JarContainer {
        ModContainer[] mods;
        String[] methodsString;
        String[] methodsRegExp;
        String[] methodsSuffix;
        String[] methodsStrsKt;

        private JarContainer() {
        }
    }

    public static class Report {
        String version = "1.12.0-3.5.1";
        String mcversion = "1.12.2";
        String date;
        JarContainer[] jars;

        public Report() {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.date = sdf.format(new Date());
        }
    }
}

