/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters.transform.transformers;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecharacters.JechConfig;
import me.towdium.jecharacters.match.PinyinTree;
import me.towdium.jecharacters.transform.Transformer;
import net.minecraft.client.util.SuffixArray;
import org.objectweb.asm.tree.MethodNode;

public class TransformerSuffix
extends Transformer.Configurable {
    public static final String PATH = "me/towdium/jecharacters/transform/transformers/TransformerSuffix$FakeSuffixArray";

    public TransformerSuffix() {
        this.reload();
    }

    @Override
    protected String[] getDefault() {
        return JechConfig.listDefaultSuffix;
    }

    @Override
    protected String[] getAdditional() {
        return JechConfig.listAdditionalSuffix;
    }

    @Override
    protected String getName() {
        return "vanilla SuffixArray";
    }

    @Override
    protected void transform(MethodNode n) {
        Transformer.transformConstruct(n, "net/minecraft/client/util/SuffixArray", PATH);
        Transformer.transformConstruct(n, "cgx", PATH);
        Transformer.transformConstruct(n, "cgz", PATH);
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    public static class FakeSuffixArray<T>
    extends SuffixArray<T> {
        PinyinTree tree = new PinyinTree();
        Int2ObjectMap<T> map = new Int2ObjectOpenHashMap();
        int count = 0;

        public void func_194057_a(T v, String k) {
            this.tree.put(k, this.count);
            this.map.put(this.count, v);
            ++this.count;
        }

        public void func_194058_a() {
        }

        public List<T> func_194055_a(String k) {
            return this.tree.search(k).stream().sorted().map(arg_0 -> this.map.get(arg_0)).collect(Collectors.toList());
        }
    }
}

