/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters.transform.transformers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.towdium.jecharacters.JechConfig;
import me.towdium.jecharacters.match.PinyinMatcher;
import me.towdium.jecharacters.match.Utilities;
import me.towdium.jecharacters.transform.Transformer;
import org.objectweb.asm.tree.MethodNode;

public class TransformerRegExp
extends Transformer.Configurable {
    static final Pattern p = Pattern.compile("a");

    public TransformerRegExp() {
        this.reload();
    }

    @Override
    protected String[] getDefault() {
        return JechConfig.listDefaultRegExp;
    }

    @Override
    protected String[] getAdditional() {
        return JechConfig.listAdditionalRegExp;
    }

    @Override
    protected String getName() {
        return "regular expression";
    }

    @Override
    protected void transform(MethodNode n) {
        Transformer.transformInvoke(n, "java/util/regex/Pattern", "matcher", "me/towdium/jecharacters/transform/transformers/TransformerRegExp", "matcher", "(Ljava/util/regex/Pattern;Ljava/lang/CharSequence;)Ljava/util/regex/Matcher;", false, 184, null, null);
        Transformer.transformInvoke(n, "java/lang/String", "matches", "me/towdium/jecharacters/transform/transformers/TransformerRegExp", "matches", "(Ljava/lang/String;Ljava/lang/CharSequence;)Z", false, 184, "(Ljava/lang/Object;)Z", "(Ljava/lang/String;)Z");
    }

    public static Matcher matcher(Pattern test, CharSequence name) {
        if (Utilities.isChinese(name)) {
            boolean ret = PinyinMatcher.contains(name.toString(), TransformerRegExp.trim(test.toString()));
            return ret ? p.matcher("a") : p.matcher("");
        }
        return test.matcher(name);
    }

    public static boolean matches(String s1, CharSequence s2) {
        return PinyinMatcher.contains(s1, TransformerRegExp.trim(s2.toString()));
    }

    private static String trim(String s) {
        boolean start = s.startsWith(".*");
        boolean end = s.endsWith(".*");
        if (start || end) {
            if (start && end && s.length() < 4) {
                end = false;
            }
            s = s.substring(start ? 2 : 0, s.length() - (end ? 2 : 0));
        }
        return s;
    }
}

