/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters.transform;

import com.google.common.collect.HashMultimap;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import me.towdium.jecharacters.JechConfig;
import me.towdium.jecharacters.core.JechCore;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public interface Transformer {
    public static Optional<MethodNode> findMethod(ClassNode c, String name) {
        Optional<MethodNode> ret = c.methods.stream().filter(methodNode -> methodNode.name.equals(name)).findFirst();
        String s = ret.isPresent() ? "," : ", not";
        JechCore.LOG.info("Finding method " + name + " in class " + c.name + s + " found.");
        return ret;
    }

    public static Optional<MethodNode> findMethod(ClassNode c, String name, String desc) {
        Optional<MethodNode> ret = c.methods.stream().filter(methodNode -> methodNode.name.equals(name)).filter(methodNode -> methodNode.desc.equals(desc)).findFirst();
        String s = ret.isPresent() ? "," : ", not";
        JechCore.LOG.info("Finding method " + name + desc + " in class " + c.name + s + " found.");
        return ret;
    }

    public static boolean transformInvoke(MethodNode methodNode, String owner, String name, String newOwner, String newName, String id, boolean isInterface, int op, @Nullable String arg1, @Nullable String arg2) {
        JechCore.LOG.info("Transforming invoke of " + owner + "." + name + " to " + newOwner + "." + newName + " in method " + methodNode.name + ".");
        ListIterator iterator = methodNode.instructions.iterator();
        boolean ret = false;
        while (iterator.hasNext()) {
            Handle h;
            MethodInsnNode insnNode;
            AbstractInsnNode node = (AbstractInsnNode)iterator.next();
            if (node instanceof MethodInsnNode && (node.getOpcode() == 182 || node.getOpcode() == 183 || node.getOpcode() == 184)) {
                insnNode = (MethodInsnNode)node;
                if (insnNode.owner.equals(owner) && insnNode.name.equals(name)) {
                    methodNode.instructions.set((AbstractInsnNode)insnNode, (AbstractInsnNode)new MethodInsnNode(op, newOwner, newName, id, isInterface));
                    ret = true;
                }
            }
            if (!(node instanceof InvokeDynamicInsnNode) || node.getOpcode() != 186 || arg1 == null || arg2 == null) continue;
            insnNode = (InvokeDynamicInsnNode)node;
            if (!(insnNode.bsmArgs[1] instanceof Handle) || !(h = (Handle)insnNode.bsmArgs[1]).getOwner().equals(owner) || !h.getName().equals(name)) continue;
            Object[] args = new Object[]{Type.getType((String)arg1), new Handle(6, newOwner, newName, id), Type.getType((String)arg2)};
            methodNode.instructions.set((AbstractInsnNode)insnNode, (AbstractInsnNode)new InvokeDynamicInsnNode(insnNode.name, insnNode.desc, insnNode.bsm, args));
            ret = true;
        }
        return ret;
    }

    public static void transformConstruct(MethodNode methodNode, String desc, String destNew) {
        JechCore.LOG.info("Transforming constructor of " + desc + " to " + destNew + " in method " + methodNode.name + ".");
        ListIterator i = methodNode.instructions.iterator();
        int cnt = 0;
        while (i.hasNext()) {
            TypeInsnNode nodeNew;
            AbstractInsnNode node = (AbstractInsnNode)i.next();
            if (node.getOpcode() == 187) {
                nodeNew = (TypeInsnNode)node;
                if (!nodeNew.desc.equals(desc)) continue;
                nodeNew.desc = destNew;
                ++cnt;
                continue;
            }
            if (node.getOpcode() != 183) continue;
            nodeNew = (MethodInsnNode)node;
            if (!nodeNew.owner.equals(desc)) continue;
            nodeNew.owner = destNew;
        }
        JechCore.LOG.info("Transformed " + cnt + " occurrences.");
    }

    public static void transformHook(MethodNode methodNode, String owner, String name, String id) {
        for (AbstractInsnNode node : methodNode.instructions) {
            if (!(node instanceof InsnNode) || node.getOpcode() != 177) continue;
            methodNode.instructions.insertBefore(node, (AbstractInsnNode)new MethodInsnNode(184, owner, name, id, false));
        }
    }

    public boolean accepts(String var1);

    public byte[] transform(byte[] var1);

    public static class MethodDecoder {
        HashMultimap<String, String> methods = HashMultimap.create();

        public static void logError(String s) {
            JechCore.LOG.info("Invalid config syntax: " + s);
        }

        public void addAll(String[] names) {
            for (String s : names) {
                String[] ss = s.split(":");
                if (ss.length == 2) {
                    this.methods.put((Object)ss[0], (Object)ss[1]);
                    continue;
                }
                MethodDecoder.logError(s);
            }
        }

        public void removeAll(String[] names) {
            for (String s : names) {
                String[] ss = s.split(":");
                if (ss.length == 2) {
                    this.methods.remove((Object)ss[0], (Object)ss[1]);
                    continue;
                }
                MethodDecoder.logError(s);
            }
        }

        public Set<String> getMethodsForClass(String c) {
            return this.methods.get((Object)c);
        }

        public boolean contains(String s) {
            return this.methods.containsKey((Object)s);
        }
    }

    public static abstract class Configurable
    extends Default {
        protected MethodDecoder md = new MethodDecoder();

        protected abstract String[] getDefault();

        protected abstract String[] getAdditional();

        protected abstract String getName();

        protected abstract void transform(MethodNode var1);

        @Override
        protected void transform(ClassNode c) {
            JechCore.LOG.info("Transforming class " + c.name + " for " + this.getName() + ".");
            Set<String> ms = this.md.getMethodsForClass(c.name.replace('/', '.'));
            if (!ms.isEmpty()) {
                c.methods.stream().filter(m -> ms.contains(m.name)).forEach(this::transform);
            } else {
                JechCore.LOG.info("No function matched in class " + c.name);
            }
        }

        @Override
        public boolean accepts(String name) {
            return this.md.contains(name);
        }

        public void reload() {
            MethodDecoder mdt = new MethodDecoder();
            mdt.addAll(this.getDefault());
            mdt.addAll(this.getAdditional());
            mdt.removeAll(JechConfig.listMethodBlacklist);
            this.md = mdt;
        }
    }

    public static abstract class Default
    implements Transformer {
        @Override
        public byte[] transform(byte[] bytes) {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(bytes);
            classReader.accept((ClassVisitor)classNode, 0);
            this.transform(classNode);
            ClassWriter classWriter = new ClassWriter(1);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }

        protected abstract void transform(ClassNode var1);
    }
}

