/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters.match.matchables;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collections;
import java.util.HashSet;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecharacters.JechConfig;
import me.towdium.jecharacters.match.Matchable;
import me.towdium.jecharacters.match.PinyinData;
import me.towdium.jecharacters.match.Utilities;

public class Pinyin
implements Matchable {
    private static LoadingCache<String, Pinyin> cache = CacheBuilder.newBuilder().concurrencyLevel(1).build((CacheLoader)new CacheLoader<String, Pinyin>(){

        @ParametersAreNonnullByDefault
        public Pinyin load(String str) {
            return new Pinyin(str);
        }
    });
    private Phoneme initial;
    private Phoneme finale;
    private Phoneme tone;

    public Pinyin(String str) {
        this.set(str);
    }

    public static Pinyin get(String str) {
        return (Pinyin)cache.getUnchecked((Object)str);
    }

    public static Pinyin[] get(char ch) {
        String[] ss = PinyinData.get(ch);
        Pinyin[] ret = new Pinyin[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            ret[i] = Pinyin.get(ss[i]);
        }
        return ret;
    }

    public static void refresh() {
        Phoneme.refresh();
        cache.asMap().forEach((s, p) -> p.set((String)s));
    }

    private void set(String str) {
        String[] elements = JechConfig.keyboard.separate(str);
        this.initial = Phoneme.get(elements[0]);
        this.finale = Phoneme.get(elements[1]);
        this.tone = Phoneme.get(elements[2]);
    }

    @Override
    public Utilities.IndexSet match(String str, int start) {
        Utilities.IndexSet ret = new Utilities.IndexSet(1);
        ret = this.initial.match(str, ret, start);
        ret.merge(this.finale.match(str, ret, start));
        ret.merge(this.tone.match(str, ret, start));
        return ret;
    }

    public char start() {
        String ret = this.initial.toString();
        if (ret.isEmpty()) {
            ret = this.finale.toString();
        }
        return ret.charAt(0);
    }

    public String toString() {
        return "" + this.initial + this.finale + this.tone;
    }

    private static class Phoneme {
        private static LoadingCache<String, Phoneme> cache = CacheBuilder.newBuilder().concurrencyLevel(1).build((CacheLoader)new CacheLoader<String, Phoneme>(){

            @ParametersAreNonnullByDefault
            public Phoneme load(String str) {
                return new Phoneme(str);
            }
        });
        String[] strs;

        public String toString() {
            return this.strs[0];
        }

        public Phoneme(String str) {
            HashSet<String> ret = new HashSet<String>();
            ret.add(str);
            if (JechConfig.enableFuzzyCh2c && str.startsWith("c")) {
                Collections.addAll(ret, "c", "ch");
            }
            if (JechConfig.enableFuzzySh2s && str.startsWith("s")) {
                Collections.addAll(ret, "s", "sh");
            }
            if (JechConfig.enableFuzzyZh2z && str.startsWith("z")) {
                Collections.addAll(ret, "z", "zh");
            }
            if (JechConfig.enableFuzzyU2v && str.startsWith("v")) {
                ret.add("u" + str.substring(1));
            }
            if (JechConfig.enableFuzzyAng2an && str.endsWith("ang") || JechConfig.enableFuzzyEng2en && str.endsWith("eng") || JechConfig.enableFuzzyIng2in && str.endsWith("ing")) {
                ret.add(str.substring(0, str.length() - 1));
            }
            if (JechConfig.enableFuzzyAng2an && str.endsWith("an") || str.endsWith("en") && JechConfig.enableFuzzyEng2en || str.endsWith("in") && JechConfig.enableFuzzyIng2in) {
                ret.add(str + 'g');
            }
            this.strs = (String[])ret.stream().map(JechConfig.keyboard::keys).toArray(String[]::new);
        }

        public static Phoneme get(String str) {
            return (Phoneme)cache.getUnchecked((Object)str);
        }

        public static void refresh() {
            cache.invalidateAll();
        }

        Utilities.IndexSet match(String source, Utilities.IndexSet idx, int start) {
            if (this.strs.length == 1 && this.strs[0].isEmpty()) {
                return new Utilities.IndexSet(idx);
            }
            Utilities.IndexSet ret = new Utilities.IndexSet();
            idx.foreach(i -> {
                for (String str : this.strs) {
                    int size = Utilities.strCmp(source, str, i + start);
                    if (i + start + size == source.length()) {
                        ret.set(i + size);
                        continue;
                    }
                    if (size != str.length()) continue;
                    ret.set(i + size);
                }
                return true;
            });
            return ret;
        }
    }
}

