/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters.match.matchables;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecharacters.match.Matchable;
import me.towdium.jecharacters.match.PinyinData;
import me.towdium.jecharacters.match.Utilities;
import me.towdium.jecharacters.match.matchables.Pinyin;

public class Char
implements Matchable {
    private static LoadingCache<Character, Char> cache = CacheBuilder.newBuilder().concurrencyLevel(1).build((CacheLoader)new CacheLoader<Character, Char>(){

        @ParametersAreNonnullByDefault
        public Char load(Character ch) {
            return new Char(ch.charValue());
        }
    });
    private Matchable[] patterns = new Matchable[0];

    private Char(char ch) {
        ArrayList<Matchable> list = new ArrayList<Matchable>();
        list.add(new Raw(ch));
        if (Utilities.isChinese(ch)) {
            String[] pinyin;
            for (String s : pinyin = PinyinData.get(ch)) {
                list.add(Pinyin.get(s));
            }
        }
        this.patterns = list.toArray(this.patterns);
    }

    public static Char get(char ch) {
        return (Char)cache.getUnchecked((Object)Character.valueOf(ch));
    }

    @Override
    public Utilities.IndexSet match(String str, int start) {
        Utilities.IndexSet ret = new Utilities.IndexSet();
        for (Matchable p : this.patterns) {
            ret.merge(p.match(str, start));
        }
        return ret;
    }

    private static class Raw
    implements Matchable {
        private char ch;

        Raw(char ch) {
            this.ch = ch;
        }

        @Override
        public Utilities.IndexSet match(String str, int start) {
            return str.charAt(start) == this.ch ? Utilities.IndexSet.ONE : Utilities.IndexSet.NONE;
        }
    }
}

