/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters.match;

import java.util.function.Predicate;
import me.towdium.jecharacters.match.PinyinTree;
import me.towdium.jecharacters.match.matchables.Pinyin;

public class Utilities {
    public static boolean isChinese(CharSequence s) {
        for (int i = s.length() - 1; i >= 0; --i) {
            if (!Utilities.isChinese(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isChinese(char i) {
        return '\u3000' <= i && i < '\ua000' || '\ue900' <= i && i < '\uea00';
    }

    public static int strCmp(String a, String b, int aStart) {
        return Utilities.strCmp(a, b, aStart, 0, Integer.MAX_VALUE);
    }

    public static int strCmp(String a, String b, int aStart, int bStart, int max) {
        int len = Math.min(a.length() - aStart, b.length() - bStart);
        len = Math.min(len, max);
        for (int i = 0; i < len; ++i) {
            if (a.charAt(i + aStart) == b.charAt(i + bStart)) continue;
            return i;
        }
        return len;
    }

    public static void refresh() {
        Pinyin.refresh();
        PinyinTree.refresh();
    }

    public static class IndexSet {
        public static final IndexSet ONE = new IndexSet(2);
        public static final IndexSet NONE = new IndexSet(0);
        int value = 0;

        public IndexSet() {
        }

        public IndexSet(IndexSet set) {
            this.value = set.value;
        }

        public IndexSet(int value) {
            this.value = value;
        }

        public void set(int index) {
            int i = 1 << index;
            this.value |= i;
        }

        public boolean get(int index) {
            int i = 1 << index;
            return (this.value & i) != 0;
        }

        public void merge(IndexSet s) {
            this.value = this.value == 1 ? s.value : (this.value = this.value | s.value);
        }

        public boolean foreach(Predicate<Integer> p) {
            int v = this.value;
            for (int i = 0; i < 7; ++i) {
                if ((v & 1) == 1 && !p.test(i)) {
                    return false;
                }
                v >>= 1;
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            this.foreach(i -> {
                builder.append(i);
                builder.append(", ");
                return true;
            });
            if (builder.length() != 0) {
                builder.delete(builder.length() - 2, builder.length());
                return builder.toString();
            }
            return "0";
        }
    }
}

