/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters.match;

import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharOpenHashSet;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import me.towdium.jecharacters.match.Utilities;
import me.towdium.jecharacters.match.matchables.Char;
import me.towdium.jecharacters.match.matchables.Pinyin;

public class PinyinTree {
    Node root = new NSlice();

    public void put(String name, int identifier) {
        for (int i = 0; i < name.length(); ++i) {
            this.root = this.root.put(name, identifier, i);
        }
    }

    public IntSet search(String s) {
        IntOpenHashSet ret = new IntOpenHashSet();
        this.root.get((IntSet)ret, s, 0);
        return ret;
    }

    public int countSlice() {
        return this.root.countSlice();
    }

    public int countMap() {
        return this.root.countMap();
    }

    public static void refresh() {
        Glue.refresh();
    }

    public static class NMap
    implements Node {
        Char2ObjectMap<Node> children;
        Glue glue;
        IntSet leaves = new IntArraySet();

        @Override
        public void get(IntSet ret, String name, int offset) {
            if (name.length() == offset) {
                this.get(ret);
            } else if (this.children != null && this.glue != null) {
                Node n = (Node)this.children.get(name.charAt(offset));
                if (n != null) {
                    n.get(ret, name, offset + 1);
                }
                this.glue.get(name, offset).forEach((c, is) -> {
                    IntIterator intIterator = is.iterator();
                    while (intIterator.hasNext()) {
                        int i = (Integer)intIterator.next();
                        ((Node)this.children.get(c)).get(ret, name, offset + i);
                    }
                });
            }
        }

        @Override
        public void get(IntSet ret) {
            ret.addAll((IntCollection)this.leaves);
            if (this.children != null) {
                this.children.forEach((p, n) -> n.get(ret));
            }
        }

        @Override
        public NMap put(String name, int identifier, int offset) {
            if (offset == name.length()) {
                if (this.leaves.size() >= 16 && this.leaves instanceof IntArraySet) {
                    this.leaves = new IntOpenHashSet((IntCollection)this.leaves);
                }
                this.leaves.add(identifier);
            } else {
                this.init();
                char ch = name.charAt(offset);
                Node sub = (Node)this.children.get(ch);
                if (sub == null) {
                    sub = new NSlice();
                    this.put(ch, sub);
                }
                sub = sub.put(name, identifier, offset + 1);
                this.children.put(ch, (Object)sub);
            }
            return this;
        }

        @Override
        public int countSlice() {
            int ret = 0;
            if (this.children != null) {
                for (Node n : this.children.values()) {
                    ret += n.countSlice();
                }
            }
            return ret;
        }

        @Override
        public int countMap() {
            int ret = 1;
            if (this.children != null) {
                for (Node n : this.children.values()) {
                    ret += n.countMap();
                }
            }
            return ret;
        }

        private void put(char ch, Node n) {
            this.init();
            if (this.children.size() >= 16 && this.children instanceof Char2ObjectArrayMap) {
                this.children = new Char2ObjectOpenHashMap(this.children);
            }
            this.children.put(ch, (Object)n);
            this.glue.put(ch);
        }

        private void init() {
            if (this.children == null || this.glue == null) {
                this.children = new Char2ObjectArrayMap();
                this.glue = new Glue();
            }
        }
    }

    public static class NSlice
    implements Node {
        Node exit = new NMap();
        String name;
        int start;
        int end;

        @Override
        public void get(IntSet ret, String name, int offset) {
            this.get(ret, name, offset, 0);
        }

        @Override
        public void get(IntSet ret) {
            this.exit.get(ret);
        }

        @Override
        public Node put(String name, int identifier, int offset) {
            if (this.name == null) {
                this.name = name;
                this.start = offset;
                this.end = name.length();
                this.exit = this.exit.put(name, identifier, this.end);
            } else {
                int length = this.end - this.start;
                int match = Utilities.strCmp(this.name, name, this.start, offset, length);
                if (match >= length) {
                    this.exit = this.exit.put(name, identifier, offset + length);
                } else {
                    this.cut(this.start + match);
                    this.exit.put(name, identifier, offset + match);
                }
            }
            return this.start == this.end ? this.exit : this;
        }

        @Override
        public int countSlice() {
            return 1 + this.exit.countSlice();
        }

        @Override
        public int countMap() {
            return this.exit.countMap();
        }

        private void cut(int offset) {
            NMap insert = new NMap();
            if (offset + 1 == this.end) {
                insert.put(this.name.charAt(offset), this.exit);
            } else {
                NSlice half = new NSlice();
                half.name = this.name;
                half.start = offset + 1;
                half.end = this.end;
                half.exit = this.exit;
                insert.put(this.name.charAt(offset), half);
            }
            this.exit = insert;
            this.end = offset;
        }

        private void get(IntSet ret, String name, int offset, int start) {
            if (this.start + start == this.end) {
                this.exit.get(ret, name, offset);
            } else if (offset == name.length()) {
                this.exit.get(ret);
            } else {
                char ch = this.name.charAt(this.start + start);
                Char.get(ch).match(name, offset).foreach(i -> {
                    this.get(ret, name, offset + i, start + 1);
                    return true;
                });
            }
        }
    }

    static interface Node {
        public void get(IntSet var1, String var2, int var3);

        public void get(IntSet var1);

        public Node put(String var1, int var2, int var3);

        public int countSlice();

        public int countMap();
    }

    static class Glue {
        Map<Pinyin, CharSet> map = new Object2ObjectArrayMap();
        Char2ObjectMap<Set<Pinyin>> index;
        static List<WeakReference<Glue>> instances = new ArrayList<WeakReference<Glue>>();

        Glue() {
        }

        public Char2ObjectMap<IntSet> get(String name, int offset) {
            Char2ObjectArrayMap ret = new Char2ObjectArrayMap();
            BiConsumer<Pinyin, CharSet> add = (arg_0, arg_1) -> Glue.lambda$get$2(name, offset, (Char2ObjectMap)ret, arg_0, arg_1);
            if (this.index != null) {
                this.index.computeIfPresent((Object)Character.valueOf(name.charAt(offset)), (b, s) -> {
                    s.forEach(p -> add.accept((Pinyin)p, this.map.get(p)));
                    return s;
                });
            } else {
                this.map.forEach(add);
            }
            return ret;
        }

        public void put(char ch) {
            if (!Utilities.isChinese(ch)) {
                return;
            }
            for (Pinyin p : Pinyin.get(ch)) {
                this.map.compute(p, (py, cs) -> {
                    if (cs == null) {
                        cs = new CharArraySet();
                        if (this.index != null) {
                            ((Set)this.index.computeIfAbsent((Object)Character.valueOf(py.start()), c -> new ObjectOpenHashSet())).add(py);
                        }
                    } else if (cs.size() >= 16 && cs instanceof CharArraySet) {
                        cs = new CharOpenHashSet((CharCollection)cs);
                    }
                    cs.add(ch);
                    return cs;
                });
            }
            if (this.map.size() >= 16 && this.index == null) {
                this.map = new Object2ObjectOpenHashMap(this.map);
                instances.add(new WeakReference<Glue>(this));
                this.index();
            }
        }

        public void index() {
            this.index = new Char2ObjectOpenHashMap();
            this.map.forEach((p, cs) -> ((Set)this.index.computeIfAbsent((Object)Character.valueOf(p.start()), c -> new ObjectOpenHashSet())).add(p));
        }

        static void refresh() {
            instances = instances.stream().filter(i -> {
                Glue g = (Glue)i.get();
                if (g != null) {
                    g.index();
                }
                return g != null;
            }).collect(Collectors.toList());
        }

        private static /* synthetic */ void lambda$get$2(String name, int offset, Char2ObjectMap ret, Pinyin p, CharSet cs) {
            p.match(name, offset).foreach(i -> {
                CharIterator charIterator = cs.iterator();
                while (charIterator.hasNext()) {
                    char c = ((Character)charIterator.next()).charValue();
                    ((IntSet)ret.computeIfAbsent((Object)Character.valueOf(c), k -> new IntArraySet())).add(i);
                }
                return true;
            });
        }
    }
}

