/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters.match;

import me.towdium.jecharacters.core.JechCore;
import me.towdium.jecharacters.match.Utilities;
import me.towdium.jecharacters.match.matchables.Char;

public class PinyinMatcher {
    public static boolean verbose = false;

    public static boolean contains(String s1, CharSequence s2) {
        boolean ret = Utilities.isChinese(s1) ? PinyinMatcher.check(s1, s2.toString()) : s1.contains(s2);
        return ret;
    }

    private static boolean check(String s1, CharSequence s2) {
        boolean b;
        if (s2 instanceof String) {
            if (s2.toString().isEmpty()) {
                b = true;
            } else {
                b = false;
                for (int i = 0; i < s1.length(); ++i) {
                    if (!PinyinMatcher.check(s2.toString(), 0, s1, i)) continue;
                    b = true;
                    break;
                }
            }
        } else {
            b = s1.contains(s2);
        }
        if (verbose) {
            JechCore.LOG.info("Full: " + s1 + ", Test: " + s2.toString() + ", -> " + b + '.');
        }
        return b;
    }

    static boolean check(String s1, int start1, String s2, int start2) {
        if (start1 == s1.length()) {
            return true;
        }
        Char r = Char.get(s2.charAt(start2));
        Utilities.IndexSet s = r.match(s1, start1);
        if (start2 == s2.length() - 1) {
            int i2 = s1.length() - start1;
            return s.get(i2);
        }
        return !s.foreach(i -> !PinyinMatcher.check(s1, start1 + i, s2, start2 + 1));
    }
}

