/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters.match;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import me.towdium.jecharacters.core.JechCore;

public class PinyinData {
    private static String[][] data;
    private static final String[] EMPTY;
    private static String[][] extra;

    public static String[] get(char ch) {
        if (ch < '\ua000') {
            return data[ch];
        }
        return extra[ch - 59648];
    }

    static {
        int i;
        EMPTY = new String[0];
        JechCore.LOG.info("Starting loading pinyin data");
        data = new String[41000][];
        String resourceName = "/assets/jecharacters/pinyin.txt";
        BufferedReader br = new BufferedReader(new InputStreamReader(PinyinData.class.getResourceAsStream(resourceName), StandardCharsets.UTF_8));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                char ch = line.charAt(0);
                String sounds = line.substring(3);
                PinyinData.data[ch] = sounds.split(", ");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PinyinData.data[40911] = new String[]{"mai4"};
        PinyinData.data[40916] = new String[]{"ge1"};
        PinyinData.data[40941] = new String[]{"ni3"};
        PinyinData.data[40940] = new String[]{"tian2"};
        PinyinData.data[40939] = new String[]{"ao4"};
        for (i = 0; i < 41000; ++i) {
            if (data[i] != null) continue;
            PinyinData.data[i] = EMPTY;
        }
        extra = new String[256][];
        PinyinData.extra[0] = new String[]{"lu2"};
        PinyinData.extra[1] = new String[]{"du4"};
        PinyinData.extra[2] = new String[]{"xi3"};
        PinyinData.extra[3] = new String[]{"bo1"};
        PinyinData.extra[4] = new String[]{"hei1"};
        PinyinData.extra[6] = new String[]{"da2"};
        PinyinData.extra[7] = new String[]{"lun2"};
        PinyinData.extra[10] = new String[]{"fu1"};
        PinyinData.extra[12] = new String[]{"li4"};
        for (i = 0; i < 256; ++i) {
            if (extra[i] != null) continue;
            PinyinData.extra[i] = EMPTY;
        }
        JechCore.LOG.info("Finished loading pinyin data");
    }
}

