/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters.match;

import java.util.HashMap;

public enum Keyboard {
    QUANPIN,
    DAQIAN;

    private static HashMap<String, String> PHONETIC_SYMBOL;
    private static HashMap<String, String> PHONETIC_SPELL;
    private static HashMap<Character, String> KEYBOARD_DAQIAN;

    public static Keyboard get(int n) {
        switch (n) {
            case 0: {
                return QUANPIN;
            }
            case 1: {
                return DAQIAN;
            }
        }
        throw new RuntimeException("Unacceptable identifier: " + n + ".");
    }

    public String[] separate(String s) {
        String str;
        if (this == DAQIAN && (str = PHONETIC_SPELL.get(s.substring(0, s.length() - 1))) != null) {
            s = str + s.charAt(s.length() - 1);
        }
        if (s.startsWith("a") || s.startsWith("e") || s.startsWith("i") || s.startsWith("o") || s.startsWith("u")) {
            return new String[]{"", s.substring(0, s.length() - 1), s.substring(s.length() - 1)};
        }
        int i = s.length() > 2 && s.charAt(1) == 'h' ? 2 : 1;
        return new String[]{s.substring(0, i), s.substring(i, s.length() - 1), s.substring(s.length() - 1)};
    }

    public String keys(String s) {
        if (this == QUANPIN) {
            return s;
        }
        String symbol = PHONETIC_SYMBOL.get(s);
        if (symbol == null) {
            throw new RuntimeException("Unrecognized element: " + s);
        }
        StringBuilder builder = new StringBuilder();
        for (char c : symbol.toCharArray()) {
            builder.append(KEYBOARD_DAQIAN.get(Character.valueOf(c)));
        }
        return builder.toString();
    }

    static {
        PHONETIC_SYMBOL = new HashMap<String, String>(){
            {
                this.put("a", "\u311a");
                this.put("o", "\u311b");
                this.put("e", "\u311c");
                this.put("er", "\u3126");
                this.put("ai", "\u311e");
                this.put("ei", "\u311f");
                this.put("ao", "\u3120");
                this.put("ou", "\u3121");
                this.put("an", "\u3122");
                this.put("en", "\u3123");
                this.put("ang", "\u3124");
                this.put("eng", "\u3125");
                this.put("ong", "\u3128\u3125");
                this.put("i", "\u3127");
                this.put("ia", "\u3127\u311a");
                this.put("iao", "\u3127\u3120");
                this.put("ie", "\u3127\u311d");
                this.put("iu", "\u3127\u3121");
                this.put("ian", "\u3127\u3122");
                this.put("in", "\u3127\u3123");
                this.put("iang", "\u3127\u3124");
                this.put("ing", "\u3127\u3125");
                this.put("iong", "\u3129\u3125");
                this.put("u", "\u3128");
                this.put("ua", "\u3128\u311a");
                this.put("uo", "\u3128\u311b");
                this.put("uai", "\u3128\u311e");
                this.put("ui", "\u3128\u311f");
                this.put("uan", "\u3128\u3122");
                this.put("un", "\u3128\u3123");
                this.put("uang", "\u3128\u3124");
                this.put("ueng", "\u3128\u3125");
                this.put("uen", "\u3129\u3123");
                this.put("v", "\u3129");
                this.put("ve", "\u3129\u311d");
                this.put("van", "\u3129\u3122");
                this.put("vang", "\u3129\u3124");
                this.put("vn", "\u3129\u3123");
                this.put("b", "\u3105");
                this.put("p", "\u3106");
                this.put("m", "\u3107");
                this.put("f", "\u3108");
                this.put("d", "\u3109");
                this.put("t", "\u310a");
                this.put("n", "\u310b");
                this.put("l", "\u310c");
                this.put("g", "\u310d");
                this.put("k", "\u310e");
                this.put("h", "\u310f");
                this.put("j", "\u3110");
                this.put("q", "\u3111");
                this.put("x", "\u3112");
                this.put("zh", "\u3113");
                this.put("ch", "\u3114");
                this.put("sh", "\u3115");
                this.put("r", "\u3116");
                this.put("z", "\u3117");
                this.put("c", "\u3118");
                this.put("s", "\u3119");
                this.put("w", "\u3128");
                this.put("y", "\u3127");
                this.put("1", "1");
                this.put("2", "2");
                this.put("3", "3");
                this.put("4", "4");
                this.put("0", "");
                this.put("", "");
            }
        };
        PHONETIC_SPELL = new HashMap<String, String>(){
            {
                this.put("yi", "i");
                this.put("you", "iu");
                this.put("yin", "in");
                this.put("ye", "ie");
                this.put("ying", "ing");
                this.put("wu", "u");
                this.put("wen", "un");
                this.put("yu", "v");
                this.put("yue", "ve");
                this.put("yuan", "van");
                this.put("yun", "vn");
                this.put("ju", "jv");
                this.put("jue", "jve");
                this.put("juan", "jvan");
                this.put("jun", "jvn");
                this.put("qu", "qv");
                this.put("que", "qve");
                this.put("quan", "qvan");
                this.put("qun", "qvn");
                this.put("xu", "xv");
                this.put("xue", "xve");
                this.put("xuan", "xvan");
                this.put("xun", "xvn");
                this.put("shi", "sh");
                this.put("si", "s");
                this.put("chi", "ch");
                this.put("ci", "c");
                this.put("zhi", "zh");
                this.put("zi", "z");
                this.put("ri", "r");
            }
        };
        KEYBOARD_DAQIAN = new HashMap<Character, String>(){
            {
                this.put(Character.valueOf('\u3107'), "a");
                this.put(Character.valueOf('\u3116'), "b");
                this.put(Character.valueOf('\u310f'), "c");
                this.put(Character.valueOf('\u310e'), "d");
                this.put(Character.valueOf('\u310d'), "e");
                this.put(Character.valueOf('\u3111'), "f");
                this.put(Character.valueOf('\u3115'), "g");
                this.put(Character.valueOf('\u3118'), "h");
                this.put(Character.valueOf('\u311b'), "i");
                this.put(Character.valueOf('\u3128'), "j");
                this.put(Character.valueOf('\u311c'), "k");
                this.put(Character.valueOf('\u3120'), "l");
                this.put(Character.valueOf('\u3129'), "m");
                this.put(Character.valueOf('\u3119'), "n");
                this.put(Character.valueOf('\u311f'), "o");
                this.put(Character.valueOf('\u3123'), "p");
                this.put(Character.valueOf('\u3106'), "q");
                this.put(Character.valueOf('\u3110'), "r");
                this.put(Character.valueOf('\u310b'), "s");
                this.put(Character.valueOf('\u3114'), "t");
                this.put(Character.valueOf('\u3127'), "u");
                this.put(Character.valueOf('\u3112'), "v");
                this.put(Character.valueOf('\u310a'), "w");
                this.put(Character.valueOf('\u310c'), "x");
                this.put(Character.valueOf('\u3117'), "y");
                this.put(Character.valueOf('\u3108'), "z");
                this.put(Character.valueOf('\u3105'), "1");
                this.put(Character.valueOf('\u3109'), "2");
                this.put(Character.valueOf('\u3113'), "5");
                this.put(Character.valueOf('\u311a'), "8");
                this.put(Character.valueOf('\u311e'), "9");
                this.put(Character.valueOf('\u3122'), "0");
                this.put(Character.valueOf('\u3126'), "-");
                this.put(Character.valueOf('\u3124'), ";");
                this.put(Character.valueOf('\u311d'), ",");
                this.put(Character.valueOf('\u3121'), ".");
                this.put(Character.valueOf('\u3125'), "/");
                this.put(Character.valueOf('1'), " ");
                this.put(Character.valueOf('2'), "6");
                this.put(Character.valueOf('3'), "3");
                this.put(Character.valueOf('4'), "4");
            }
        };
    }
}

