/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters;

import com.google.common.base.CaseFormat;
import java.io.File;
import me.towdium.jecharacters.match.Keyboard;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class JechConfig {
    public static Configuration config;
    public static Object empty;
    public static String[] listAdditionalString;
    public static String[] listAdditionalRegExp;
    public static String[] listAdditionalSuffix;
    public static String[] listAdditionalStrsKt;
    public static String[] listDefaultString;
    public static String[] listDefaultRegExp;
    public static String[] listDefaultSuffix;
    public static String[] listDefaultStrsKt;
    public static String[] listDumpClassFunc;
    public static String[] listMethodBlacklist;
    public static boolean enableJEI;
    public static boolean enablePsi;
    public static boolean enableProjectEX;
    public static boolean enableFuzzyZh2z;
    public static boolean enableFuzzySh2s;
    public static boolean enableFuzzyCh2c;
    public static boolean enableFuzzyAng2an;
    public static boolean enableFuzzyIng2in;
    public static boolean enableFuzzyEng2en;
    public static boolean enableFuzzyU2v;
    public static boolean enableForceQuote;
    public static boolean enableChatHelp;
    public static boolean enableDumpClassName;
    public static Keyboard keyboard;

    public static void init(File location) {
        config = new Configuration(new File(location, "config/JustEnoughCharacters.cfg"), "1.12.0-3.5.1");
        config.load();
        JechConfig.initProperties();
        JechConfig.setValue();
        JechConfig.update();
    }

    public static void update() {
        for (Item i : Item.values()) {
            i.sync();
        }
        config.save();
    }

    public static void setValue() {
        Item.LIST_DEFAULT_REGEXP.getProperty().set((String[])Item.LIST_DEFAULT_REGEXP.getDefault());
        Item.LIST_DEFAULT_STRING.getProperty().set((String[])Item.LIST_DEFAULT_STRING.getDefault());
    }

    public static void initProperties() {
        for (Item item : Item.values()) {
            item.init();
        }
    }

    static {
        listAdditionalString = new String[0];
        listAdditionalRegExp = new String[0];
        listAdditionalSuffix = new String[0];
        listAdditionalStrsKt = new String[0];
        listDefaultString = new String[0];
        listDefaultRegExp = new String[0];
        listDefaultSuffix = new String[0];
        listDefaultStrsKt = new String[0];
        listDumpClassFunc = new String[0];
        listMethodBlacklist = new String[0];
        enableJEI = true;
        enablePsi = true;
        enableProjectEX = true;
        enableFuzzyZh2z = false;
        enableFuzzySh2s = false;
        enableFuzzyCh2c = false;
        enableFuzzyAng2an = false;
        enableFuzzyIng2in = false;
        enableFuzzyEng2en = false;
        enableFuzzyU2v = false;
        enableForceQuote = false;
        enableChatHelp = true;
        enableDumpClassName = false;
        keyboard = Keyboard.QUANPIN;
    }

    public static enum Type {
        BOOLEAN,
        LIST_STRING,
        INTEGER,
        ERROR;

    }

    public static enum Category {
        GENERAL,
        FUZZY,
        TRANSFORM;


        public String toString() {
            switch (this) {
                case GENERAL: {
                    return "general";
                }
                case FUZZY: {
                    return "fuzzy";
                }
                case TRANSFORM: {
                    return "transform";
                }
            }
            throw new RuntimeException("Runtime error.");
        }
    }

    public static enum Item {
        LIST_ADDITIONAL_STRING,
        LIST_ADDITIONAL_REGEXP,
        LIST_ADDITIONAL_SUFFIX,
        LIST_ADDITIONAL_STRSKT,
        LIST_DEFAULT_STRING,
        LIST_DEFAULT_REGEXP,
        LIST_DEFAULT_SUFFIX,
        LIST_DEFAULT_STRSKT,
        LIST_DUMP_CLASS_FUNC,
        LIST_METHOD_BLACKLIST,
        ENABLE_JEI,
        ENABLE_PSI,
        ENABLE_PROJECTEX,
        ENABLE_CHAT_HELP,
        ENABLE_FUZZY_ZH2Z,
        ENABLE_FUZZY_SH2S,
        ENABLE_FUZZY_CH2C,
        ENABLE_FUZZY_ANG2AN,
        ENABLE_FUZZY_ING2IN,
        ENABLE_FUZZY_ENG2EN,
        ENABLE_FUZZY_U2V,
        ENABLE_FORCE_QUOTE,
        ENABLE_DUMP_CLASS_NAME,
        INT_KEYBOARD;


        public String getComment() {
            switch (this) {
                case LIST_ADDITIONAL_STRING: {
                    return "Give a list of methods to transform, of which uses \"String.contains\" to match.\nThe format is \"full.class.Path$InnerClass:methodName\"\nThis list will also contain data fetched from online record.";
                }
                case LIST_ADDITIONAL_REGEXP: {
                    return "Give a list of methods to transform, of which uses regular expression to match.\nThe format is \"full.class.path$InnerClass:methodName\"\nThis list will also contain data fetched from online record.";
                }
                case LIST_ADDITIONAL_SUFFIX: {
                    return "Give a list of methods to transform, of which uses vanilla SuffixArray to match.\nThe format is \"full.class.path$InnerClass:methodName\"\nThis list will also contain data fetched from online record.";
                }
                case LIST_ADDITIONAL_STRSKT: {
                    return "Give a list of methods to transform, of which uses Kotlin Strings to match.\nThe format is \"full.class.path$InnerClass:methodName\"\nThis list will also contain data fetched from online record.";
                }
                case LIST_DEFAULT_STRING: {
                    return "Default list of methods to transform, of which uses \"String.contains\" to match.\nThis list is maintained by the mod and will have no effect if you change it.";
                }
                case LIST_DEFAULT_REGEXP: {
                    return "Default list of methods to transform, of which uses regular expression to match.\nThis list is maintained by the mod and will have no effect if you change it.";
                }
                case LIST_DEFAULT_SUFFIX: {
                    return "Default list of methods to transform, of which uses vanilla SuffixArray to match.\nThis list is maintained by the mod and will have no effect if you change it.";
                }
                case LIST_DEFAULT_STRSKT: {
                    return "Default list of methods to transform, of which uses Kotlin Strings to match.\nThis list is maintained by the mod and will have no effect if you change it.";
                }
                case LIST_DUMP_CLASS_FUNC: {
                    return "Dump all the methods in this class into log. Format is \"full.class.Path$InnerClass\".";
                }
                case LIST_METHOD_BLACKLIST: {
                    return "Put the strings in default list here to disable transform for certain method";
                }
                case ENABLE_JEI: {
                    return "Set to false to disable JEI support.";
                }
                case ENABLE_PSI: {
                    return "Set to false to disable PSI support.";
                }
                case ENABLE_PROJECTEX: {
                    return "Set to false to disable Project EX support.";
                }
                case ENABLE_FUZZY_ZH2Z: {
                    return "Set to true to enable fuzzy Zh <=> Z";
                }
                case ENABLE_FUZZY_SH2S: {
                    return "Set to true to enable fuzzy Sh <=> S";
                }
                case ENABLE_FUZZY_CH2C: {
                    return "Set to true to enable fuzzy Ch <=> C";
                }
                case ENABLE_FUZZY_ANG2AN: {
                    return "Set to true to enable fuzzy Ang <=> An";
                }
                case ENABLE_FUZZY_ING2IN: {
                    return "Set to true to enable fuzzy Ing <=> In";
                }
                case ENABLE_FUZZY_ENG2EN: {
                    return "Set to true to enable fuzzy Eng <=> En";
                }
                case ENABLE_FUZZY_U2V: {
                    return "Set to true to enable fuzzy U <=> V";
                }
                case ENABLE_FORCE_QUOTE: {
                    return "Set to true to disable JEI keyword separation";
                }
                case ENABLE_CHAT_HELP: {
                    return "Set to false to disable all the chat messages";
                }
                case ENABLE_DUMP_CLASS_NAME: {
                    return "Set to true to dump all the class names";
                }
                case INT_KEYBOARD: {
                    return "Choose keyboard: 0 for quanpin, 1 for phonetic (Daqian)";
                }
            }
            return "";
        }

        public Type getType() {
            switch (this) {
                case LIST_ADDITIONAL_STRING: 
                case LIST_ADDITIONAL_REGEXP: 
                case LIST_ADDITIONAL_SUFFIX: 
                case LIST_ADDITIONAL_STRSKT: 
                case LIST_DEFAULT_STRING: 
                case LIST_DEFAULT_REGEXP: 
                case LIST_DEFAULT_SUFFIX: 
                case LIST_DEFAULT_STRSKT: 
                case LIST_DUMP_CLASS_FUNC: 
                case LIST_METHOD_BLACKLIST: {
                    return Type.LIST_STRING;
                }
                case ENABLE_JEI: 
                case ENABLE_PSI: 
                case ENABLE_PROJECTEX: 
                case ENABLE_FUZZY_ZH2Z: 
                case ENABLE_FUZZY_SH2S: 
                case ENABLE_FUZZY_CH2C: 
                case ENABLE_FUZZY_ANG2AN: 
                case ENABLE_FUZZY_ING2IN: 
                case ENABLE_FUZZY_ENG2EN: 
                case ENABLE_FUZZY_U2V: 
                case ENABLE_FORCE_QUOTE: 
                case ENABLE_CHAT_HELP: 
                case ENABLE_DUMP_CLASS_NAME: {
                    return Type.BOOLEAN;
                }
                case INT_KEYBOARD: {
                    return Type.INTEGER;
                }
            }
            return Type.ERROR;
        }

        public Object getDefault() {
            switch (this) {
                case LIST_ADDITIONAL_STRING: 
                case LIST_ADDITIONAL_REGEXP: 
                case LIST_ADDITIONAL_SUFFIX: 
                case LIST_ADDITIONAL_STRSKT: 
                case LIST_DUMP_CLASS_FUNC: 
                case LIST_METHOD_BLACKLIST: {
                    return new String[0];
                }
                case LIST_DEFAULT_STRING: {
                    return new String[]{"mezz.jei.ItemFilter$FilterPredicate:stringContainsTokens", "com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterName:accepts", "com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterTooltip:accepts", "com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterMod:test", "com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterName:test", "com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterOreDict:lambda$test$0", "com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterTooltip:test", "com.rwtema.extrautils2.transfernodes.TileIndexer$ContainerIndexer$WidgetItemRefButton:lambda$getRef$0", "crazypants.enderio.machine.invpanel.client.ItemFilter$ModFilter:matches", "crazypants.enderio.machine.invpanel.client.ItemFilter$NameFilter:matches", "vazkii.psi.client.gui.GuiProgrammer:shouldShow", "vazkii.botania.client.gui.lexicon.GuiLexiconIndex:matchesSearch", "de.ellpeck.actuallyadditions.mod.booklet.entry.BookletEntry:fitsFilter", "de.ellpeck.actuallyadditions.mod.booklet.entry.BookletEntry:getChaptersForDisplay", "com.zerofall.ezstorage.gui.client.GuiStorageCore:updateFilteredItems", "io.github.elytra.copo.inventory.ContainerVT:updateSlots", "io.github.elytra.copo.inventory.ContainerTerminal:updateSlots", "net.minecraft.client.gui.inventory.GuiContainerCreative:updateFilteredItems", "bmp:updateFilteredItems", "appeng.client.gui.implementation.GuiInterfaceTerminal:refreshList", "appeng.client.gui.implementation.GuiInterfaceTerminal:itemStackMatchesSearchTerm", "appeng.client.gui.implementations.GuiInterfaceTerminal:refreshList", "appeng.client.gui.implementations.GuiInterfaceTerminal:itemStackMatchesSearchTerm", "pers.towdium.just_enough_calculation.gui.guis.GuiPicker:updateLayout", "io.github.elytra.correlated.inventory.ContainerTerminal:updateSlots", "com.elytradev.correlated.inventory.ContainerTerminal:updateSlots", "sonar.logistics.client.gui.GuiFluidReader:getGridList", "sonar.logistics.client.gui.GuiGuide:updateSearchList", "sonar.logistics.client.gui.GuiInventoryReader:getGridList", "sonar.logistics.client.gui.GuiWirelessStorageReader:getGridList", "sonar.logistics.core.tiles.readers.fluids.GuiFluidReader:getGridList", "sonar.logistics.core.tiles.readers.items.GuiInventoryReader:getGridList", "sonar.logistics.core.items.wirelessstoragereader.GuiWirelessStorageReader:getGridList", "sonar.logistics.core.items.guide.GuiGuide:updateSearchList", "binnie.core.machines.storage.SearchDialog:updateSearch", "net.blay09.mods.cookingforblockheads.container.ContainerRecipeBook:search", "mcjty.rftools.blocks.storagemonitor.GuiStorageScanner:updateContentsList", "mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity:lambda$null$20", "mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity:lambda$makeSearchPredicate$24", "mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity:lambda$makeSearchPredicate$20", "mcjty.rftools.blocks.storage.GuiModularStorage:updateList", "mcjty.rftools.blocks.shaper.LocatorTileEntity:checkFilter", "mcjty.rftools.items.netmonitor.GuiNetworkMonitor:populateList", "moze_intel.projecte.gameObjs.container.inventory.TransmutationInventory:doesItemMatchFilter", "moze_intel.projecte.utils.ItemSearchHelper$DefaultSearch:doesItemMatchFilter_", "org.cyclops.integrateddynamics.core.client.gui.GuiTextFieldDropdown:func_146201_a", "blusunrize.immersiveengineering.api.ManualPageBlueprint:listForSearch", "blusunrize.lib.manual.ManualPages$Crafting:listForSearch", "blusunrize.lib.manual.ManualPages$CraftingMulti:listForSearch", "blusunrize.lib.manual.ManualPages$ItemDisplay:listForSearch", "blusunrize.lib.manual.gui.GuiManual:func_73869_a", "betterquesting.client.gui.editors.GuiPrerequisiteEditor:RefreshSearch", "betterquesting.client.gui.editors.GuiQuestLineEditorB:RefreshSearch", "betterquesting.client.gui.editors.json.GuiJsonEntitySelection:updateSearch", "betterquesting.client.gui.editors.json.GuiJsonFluidSelection:doSearch", "betterquesting.client.gui.editors.json.GuiJsonItemSelection:doSearch", "betterquesting.api2.client.gui.panels.lists.CanvasEntityDatabase:queryMatches", "betterquesting.api2.client.gui.panels.lists.CanvasFileDirectory:queryMatches", "betterquesting.api2.client.gui.panels.lists.CanvasFluidDatabase:queryMatches", "betterquesting.api2.client.gui.panels.lists.CanvasItemDatabase:queryMatches", "betterquesting.api2.client.gui.panels.lists.CanvasQuestDatabase:queryMatches", "com.elytradev.correlated.C28n:contains", "vswe.stevesfactory.components.ComponentMenuContainer$2:updateSearch", "vswe.stevesfactory.components.ComponentMenuFluid:updateSearch", "vswe.stevesfactory.components.ComponentMenuItem:updateSearch", "com.mia.props.client.container.GuiDecobench:refreshButtons", "mrriegel.storagenetwork.gui.GuiRequest:match", "vazkii.quark.client.feature.ChestSearchBar:lambda$namesMatch$0", "logisticspipes.gui.orderer.GuiOrderer:isSearched", "logisticspipes.gui.orderer.GuiRequestTable:isSearched", "us.getfluxed.controlsearch.client.gui.GuiNewControls:refreshKeys", "me.towdium.jecalculation.utils.Utilities$I18n:contains", "net.blay09.mods.farmingforblockheads.container.ContainerMarketClient:applyFilters", "mrriegel.storagenetwork.gui.GuiContainerStorageInventory:doesStackMatchSearch", "mrriegel.storagenetwork.gui.fb.GuiFastNetworkCrafter:doesStackMatchSearch", "com.feed_the_beast.ftblib.lib.gui.misc.GuiButtonListBase$1:add", "com.feed_the_beast.ftblib.lib.gui.misc.GuiSelectItemStack$ItemStackButton:shouldAdd", "com.latmod.mods.projectex.gui.GuiTableBase:updateValidItemList", "amerifrance.guideapi.gui.GuiSearch:getMatches", "thaumcraft.client.gui.GuiResearchBrowser:updateSearch", "astavie.thermallogistics.client.gui.GuiTerminalItem:updateFilter"};
                }
                case LIST_DEFAULT_REGEXP: {
                    return new String[]{"appeng.client.me.FluidRepo:updateView", "appeng.client.me.ItemRepo:updateView", "codechicken.nei.ItemList$PatternItemFilter:matches", "codechicken.nei.util.ItemList$PatternItemFilter:matches", "org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipartAspects$1:apply", "org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase$1:apply", "p455w0rd.wct.client.me.ItemRepo:updateView", "vazkii.quark.client.feature.ChestSearchBar:lambda$namesMatch$2", "org.cyclops.integratedterminals.capability.ingredient.IngredientComponentTerminalStorageHandlerFluidStack:lambda$getInstanceFilterPredicate$1", "org.cyclops.integratedterminals.capability.ingredient.IngredientComponentTerminalStorageHandlerFluidStack:lambda$getInstanceFilterPredicate$4", "org.cyclops.integratedterminals.capability.ingredient.IngredientComponentTerminalStorageHandlerItemStack:lambda$getInstanceFilterPredicate$1", "org.cyclops.integratedterminals.capability.ingredient.IngredientComponentTerminalStorageHandlerItemStack:lambda$getInstanceFilterPredicate$6", "org.cyclops.integratedterminals.capability.ingredient.IngredientComponentTerminalStorageHandlerItemStack:lambda$null$2", "org.cyclops.integratedterminals.capability.ingredient.IngredientComponentTerminalStorageHandlerItemStack:lambda$null$4", "thaumicenergistics.client.gui.helpers.MERepo:searchName", "thaumicenergistics.client.gui.helpers.MERepo:searchTooltip", "thaumicenergistics.client.gui.helpers.MERepo:searchMod", "thaumicenergistics.client.gui.helpers.MERepo:lambda$searchAspects$5"};
                }
                case LIST_DEFAULT_SUFFIX: {
                    return new String[]{"net.minecraft.client.util.PinyinTree:<init>", "net.minecraft.client.util.PinyinTree:recalculate", "cgw:<init>", "cgw:a", "buildcraft.lib.client.guide.GuideManager:generateContentsPage"};
                }
                case LIST_DEFAULT_STRSKT: {
                    return new String[]{"com.cout970.magneticraft.features.multiblocks.ContainerShelvingUnit:filterSlots", "com.cout970.magneticraft.features.multiblocks.ContainerShelvingUnit$filterSlots$1:invoke"};
                }
                case ENABLE_FUZZY_ZH2Z: 
                case ENABLE_FUZZY_SH2S: 
                case ENABLE_FUZZY_CH2C: 
                case ENABLE_FUZZY_ANG2AN: 
                case ENABLE_FUZZY_ING2IN: 
                case ENABLE_FUZZY_ENG2EN: 
                case ENABLE_FUZZY_U2V: 
                case ENABLE_FORCE_QUOTE: 
                case ENABLE_DUMP_CLASS_NAME: {
                    return false;
                }
                case ENABLE_JEI: 
                case ENABLE_PSI: 
                case ENABLE_PROJECTEX: 
                case ENABLE_CHAT_HELP: {
                    return true;
                }
                case INT_KEYBOARD: {
                    return 0;
                }
            }
            return empty;
        }

        public void sync() {
            switch (this) {
                case LIST_ADDITIONAL_STRING: {
                    listAdditionalString = this.getProperty().getStringList();
                    break;
                }
                case LIST_ADDITIONAL_REGEXP: {
                    listAdditionalRegExp = this.getProperty().getStringList();
                    break;
                }
                case LIST_ADDITIONAL_SUFFIX: {
                    listAdditionalSuffix = this.getProperty().getStringList();
                    break;
                }
                case LIST_ADDITIONAL_STRSKT: {
                    listAdditionalStrsKt = this.getProperty().getStringList();
                    break;
                }
                case LIST_DEFAULT_STRING: {
                    listDefaultString = this.getProperty().getStringList();
                    break;
                }
                case LIST_DEFAULT_REGEXP: {
                    listDefaultRegExp = this.getProperty().getStringList();
                    break;
                }
                case LIST_DEFAULT_SUFFIX: {
                    listDefaultSuffix = this.getProperty().getStringList();
                    break;
                }
                case LIST_DEFAULT_STRSKT: {
                    listDefaultStrsKt = this.getProperty().getStringList();
                    break;
                }
                case LIST_DUMP_CLASS_FUNC: {
                    listDumpClassFunc = this.getProperty().getStringList();
                    break;
                }
                case LIST_METHOD_BLACKLIST: {
                    listMethodBlacklist = this.getProperty().getStringList();
                    break;
                }
                case ENABLE_JEI: {
                    enableJEI = this.getProperty().getBoolean();
                    break;
                }
                case ENABLE_PSI: {
                    enablePsi = this.getProperty().getBoolean();
                    break;
                }
                case ENABLE_PROJECTEX: {
                    enableProjectEX = this.getProperty().getBoolean();
                    break;
                }
                case ENABLE_FUZZY_ZH2Z: {
                    enableFuzzyZh2z = this.getProperty().getBoolean();
                    break;
                }
                case ENABLE_FUZZY_SH2S: {
                    enableFuzzySh2s = this.getProperty().getBoolean();
                    break;
                }
                case ENABLE_FUZZY_CH2C: {
                    enableFuzzyCh2c = this.getProperty().getBoolean();
                    break;
                }
                case ENABLE_FUZZY_ANG2AN: {
                    enableFuzzyAng2an = this.getProperty().getBoolean();
                    break;
                }
                case ENABLE_FUZZY_ING2IN: {
                    enableFuzzyIng2in = this.getProperty().getBoolean();
                    break;
                }
                case ENABLE_FUZZY_ENG2EN: {
                    enableFuzzyEng2en = this.getProperty().getBoolean();
                    break;
                }
                case ENABLE_FUZZY_U2V: {
                    enableFuzzyU2v = this.getProperty().getBoolean();
                    break;
                }
                case ENABLE_FORCE_QUOTE: {
                    enableForceQuote = this.getProperty().getBoolean();
                    break;
                }
                case INT_KEYBOARD: {
                    keyboard = Keyboard.get(this.getProperty().getInt());
                    break;
                }
                case ENABLE_CHAT_HELP: {
                    enableChatHelp = this.getProperty().getBoolean();
                }
                case ENABLE_DUMP_CLASS_NAME: {
                    enableDumpClassName = this.getProperty().getBoolean();
                }
            }
        }

        public Category getCategory() {
            switch (this) {
                case LIST_ADDITIONAL_STRING: 
                case LIST_ADDITIONAL_REGEXP: 
                case LIST_ADDITIONAL_SUFFIX: 
                case LIST_ADDITIONAL_STRSKT: 
                case LIST_DEFAULT_STRING: 
                case LIST_DEFAULT_REGEXP: 
                case LIST_DEFAULT_SUFFIX: 
                case LIST_DEFAULT_STRSKT: 
                case LIST_METHOD_BLACKLIST: {
                    return Category.TRANSFORM;
                }
                case ENABLE_FUZZY_ZH2Z: 
                case ENABLE_FUZZY_SH2S: 
                case ENABLE_FUZZY_CH2C: 
                case ENABLE_FUZZY_ANG2AN: 
                case ENABLE_FUZZY_ING2IN: 
                case ENABLE_FUZZY_ENG2EN: 
                case ENABLE_FUZZY_U2V: {
                    return Category.FUZZY;
                }
                case LIST_DUMP_CLASS_FUNC: 
                case ENABLE_JEI: 
                case ENABLE_PSI: 
                case ENABLE_PROJECTEX: 
                case ENABLE_FORCE_QUOTE: 
                case ENABLE_CHAT_HELP: 
                case ENABLE_DUMP_CLASS_NAME: 
                case INT_KEYBOARD: {
                    return Category.GENERAL;
                }
            }
            throw new RuntimeException("Internal error.");
        }

        public Property init() {
            switch (this.getType()) {
                case BOOLEAN: {
                    return config.get(this.getCategory().toString(), this.toString(), ((Boolean)this.getDefault()).booleanValue(), this.getComment());
                }
                case LIST_STRING: {
                    return config.get(this.getCategory().toString(), this.toString(), (String[])this.getDefault(), this.getComment());
                }
                case INTEGER: {
                    return config.get(this.getCategory().toString(), this.toString(), ((Integer)this.getDefault()).intValue(), this.getComment());
                }
            }
            throw new RuntimeException("Internal error.");
        }

        public Property getProperty() {
            return config.getCategory(this.getCategory().toString()).get(this.toString());
        }

        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, super.toString());
        }
    }
}

