/*
 * Decompiled with CFR 0.152.
 */
package moretweaker.bewitchment;

import com.bewitchment.api.registry.DistilleryRecipe;
import com.blamejared.mtlib.helpers.InputHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import moretweaker.Inputs;
import moretweaker.MoreTweaker;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="moretweaker.bewitchment.Distillery")
@ZenRegister
@ModOnly(value="bewitchment")
public class Distillery {
    @ZenMethod
    public static void addRecipe(IItemStack[] outputs, IIngredient[] inputs) {
        if (outputs.length > 6) {
            CraftTweakerAPI.logError((String)"Recipes for the distillery may not have more than 6 outputs.");
        }
        if (inputs.length > 6) {
            CraftTweakerAPI.logError((String)"Recipes for the distillery may not have more than 6 inputs.");
        }
        if (outputs.length > 6 || inputs.length > 6) {
            return;
        }
        final List<ItemStack> out = Arrays.asList(InputHelper.toStacks((IItemStack[])outputs));
        final List in = Arrays.stream(Inputs.getParts(inputs)).map(c -> c.ingredient).collect(Collectors.toList());
        MoreTweaker.queuePostInitAction(new IAction(){

            public void apply() {
                MoreTweaker.forgeAdd(DistilleryRecipe.class, new DistilleryRecipe(MoreTweaker.newRL(), in, out));
            }

            public String describe() {
                return "Adds a recipe to the witches distillery.";
            }
        });
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        final Object out = Inputs.getObject(output);
        MoreTweaker.queuePostInitAction(new IAction(){

            public void apply() {
                MoreTweaker.forgeRemove(DistilleryRecipe.class, r -> Inputs.matchesForRemoval(out, r.output));
            }

            public String describe() {
                return "Removes some recipes from the witches distillery.";
            }
        });
    }

    @ZenMethod
    public static void removeAll() {
        MoreTweaker.queuePostInitAction(new IAction(){

            public void apply() {
                MoreTweaker.forgeRemove(DistilleryRecipe.class, r -> true);
            }

            public String describe() {
                return "Removes all recipes from the witches distillery.";
            }
        });
    }
}

