/*
 * Decompiled with CFR 0.152.
 */
package moretweaker.betweenlands;

import com.blamejared.mtlib.helpers.InputHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import moretweaker.CraftingPart;
import moretweaker.Inputs;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thebetweenlands.api.IBetweenlandsAPI;
import thebetweenlands.api.recipes.IPestleAndMortarRecipe;
import thebetweenlands.common.BetweenlandsAPI;
import thebetweenlands.common.recipe.misc.PestleAndMortarRecipe;

@ZenClass(value="moretweaker.betweenlands.Mortar")
@ZenRegister
@ModOnly(value="thebetweenlands")
public class Mortar {
    @ZenMethod
    public static void addRecipe(IIngredient input, IItemStack output) {
        final ItemStack out = InputHelper.toStack((IItemStack)output);
        final CraftingPart in = Inputs.getPart(input);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                for (ItemStack stack : in.toStackList()) {
                    BetweenlandsAPI.getInstance().registerPestleAndMortarRecipe((IPestleAndMortarRecipe)new PestleAndMortarRecipe(out, stack));
                }
            }

            public String describe() {
                return "Adds some Pestle&Mortar recipes";
            }
        });
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        final Object out = Inputs.getObject(output);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                ArrayList recipes = new ArrayList();
                BetweenlandsAPI.getInstance().getPestleAndMortarRecipes().forEach(r -> {
                    if (Inputs.matchesForRemoval(out, r.getOutput(r.getInputs()))) {
                        recipes.add(r);
                    }
                });
                recipes.forEach(arg_0 -> ((IBetweenlandsAPI)BetweenlandsAPI.getInstance()).unregisterPestleAndMortarRecipe(arg_0));
            }

            public String describe() {
                return "Removes some Pestle&Mortar recipes";
            }
        });
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                ArrayList allRecipes = new ArrayList(BetweenlandsAPI.getInstance().getPestleAndMortarRecipes());
                allRecipes.forEach(arg_0 -> ((IBetweenlandsAPI)BetweenlandsAPI.getInstance()).unregisterPestleAndMortarRecipe(arg_0));
            }

            public String describe() {
                return "Removes all recipes for Pestle&Mortar";
            }
        });
    }
}

