/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.asm.module;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import squeek.applecore.asm.ASMConstants;
import squeek.applecore.asm.IClassTransformerModule;
import squeek.asmhelper.applecore.ASMHelper;
import squeek.asmhelper.applecore.ObfHelper;

public class ModuleExhaustingActions
implements IClassTransformerModule {
    @Override
    public String[] getClassesToTransform() {
        return new String[]{"net.minecraft.entity.player.EntityPlayer", "net.minecraft.block.Block", "net.minecraft.block.BlockContainer", "net.minecraft.block.BlockIce", "net.minecraft.potion.Potion"};
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraft.entity.player.EntityPlayer")) {
            ClassNode classNode = ASMHelper.readClassFromBytes(basicClass);
            MethodNode jumpMethod = ASMHelper.findMethodNodeOfClass(classNode, ObfHelper.isObfuscated() ? "func_70664_aZ" : "jump", "()V");
            if (jumpMethod == null) {
                throw new RuntimeException("EntityPlayer.jump method not found");
            }
            this.patchSimpleAddExhaustionCall(classNode, jumpMethod, 1, "NORMAL_JUMP");
            this.patchSimpleAddExhaustionCall(classNode, jumpMethod, 0, "SPRINTING_JUMP");
            MethodNode damageEntityMethod = ASMHelper.findMethodNodeOfClass(classNode, ObfHelper.isObfuscated() ? "func_70665_d" : "damageEntity", ASMHelper.toMethodDescriptor("V", "net.minecraft.util.DamageSource", "F"));
            if (damageEntityMethod == null) {
                throw new RuntimeException("EntityPlayer.damageEntity method not found");
            }
            this.patchDamageEntity(damageEntityMethod);
            MethodNode attackEntityMethod = ASMHelper.findMethodNodeOfClass(classNode, ObfHelper.isObfuscated() ? "func_71059_n" : "attackTargetEntityWithCurrentItem", ASMHelper.toMethodDescriptor("V", "net.minecraft.entity.Entity"));
            if (attackEntityMethod == null) {
                throw new RuntimeException("EntityPlayer.attackTargetEntityWithCurrentItem method not found");
            }
            this.patchSimpleAddExhaustionCall(classNode, attackEntityMethod, 0, "ATTACK_ENTITY");
            MethodNode addMovementStatMethod = ASMHelper.findMethodNodeOfClass(classNode, ObfHelper.isObfuscated() ? "func_71000_j" : "addMovementStat", ASMHelper.toMethodDescriptor("V", "D", "D", "D"));
            if (addMovementStatMethod == null) {
                throw new RuntimeException("EntityPlayer.addMovementStat method not found");
            }
            this.patchMovementStat(addMovementStatMethod, 0, "MOVEMENT_DIVE");
            this.patchMovementStat(addMovementStatMethod, 1, "MOVEMENT_SWIM");
            this.patchMovementStat(addMovementStatMethod, 2, "MOVEMENT_SPRINT");
            this.patchMovementStat(addMovementStatMethod, 3, "MOVEMENT_CROUCH");
            this.patchMovementStat(addMovementStatMethod, 4, "MOVEMENT_WALK");
            return ASMHelper.writeClassToBytes(classNode);
        }
        if (transformedName.equals("net.minecraft.block.Block") || transformedName.equals("net.minecraft.block.BlockContainer") || transformedName.equals("net.minecraft.block.BlockIce")) {
            ClassNode classNode = ASMHelper.readClassFromBytes(basicClass);
            String methodDesc = ASMHelper.toMethodDescriptor("V", "net.minecraft.world.World", "net.minecraft.entity.player.EntityPlayer", "net.minecraft.util.math.BlockPos", "net.minecraft.block.state.IBlockState", "net.minecraft.tileentity.TileEntity", "net.minecraft.item.ItemStack");
            MethodNode harvestBlock = ASMHelper.findMethodNodeOfClass(classNode, ObfHelper.isObfuscated() ? "func_180657_a" : "harvestBlock", methodDesc);
            if (harvestBlock == null) {
                throw new RuntimeException("Block.harvestBlock method not found in class " + classNode.name + " with desc " + methodDesc);
            }
            this.patchSimpleAddExhaustionCall(classNode, harvestBlock, 0, "HARVEST_BLOCK");
            return ASMHelper.writeClassToBytes(classNode);
        }
        if (transformedName.equals("net.minecraft.potion.Potion")) {
            ClassNode classNode = ASMHelper.readClassFromBytes(basicClass);
            MethodNode performEffect = ASMHelper.findMethodNodeOfClass(classNode, ObfHelper.isObfuscated() ? "func_76394_a" : "performEffect", ASMHelper.toMethodDescriptor("V", "net.minecraft.entity.EntityLivingBase", "I"));
            if (performEffect == null) {
                throw new RuntimeException("Potion.performEffect method not found");
            }
            AbstractInsnNode call = this.getAddExhaustionCall(performEffect);
            AbstractInsnNode load = ASMHelper.findPreviousInstructionWithOpcode(call, 192);
            if (load == null) {
                throw new RuntimeException("Unexpected instruction pattern found in Potion.performEffect:\n" + ASMHelper.getInsnListAsString(performEffect.instructions));
            }
            this.patchAddExhaustionCall(performEffect.instructions, load, call, 1, "HUNGER_POTION");
            performEffect.instructions.insert(load.getNext(), (AbstractInsnNode)new TypeInsnNode(192, ObfHelper.getInternalClassName("net.minecraft.entity.player.EntityPlayer")));
            return ASMHelper.writeClassToBytes(classNode);
        }
        return basicClass;
    }

    private void patchSimpleAddExhaustionCall(ClassNode classNode, MethodNode method, int patternIndex, String exhaustingActionEnum) {
        AbstractInsnNode start = null;
        AbstractInsnNode haystackStart = method.instructions.getFirst();
        for (int i = 0; i <= patternIndex; ++i) {
            InsnList needle = new InsnList();
            needle.add((AbstractInsnNode)new VarInsnNode(25, -1));
            needle.add((AbstractInsnNode)new LdcInsnNode((Object)"*"));
            needle.add((AbstractInsnNode)new MethodInsnNode(182, ObfHelper.getInternalClassName("net.minecraft.entity.player.EntityPlayer"), ObfHelper.isObfuscated() ? "func_71020_j" : "addExhaustion", ASMHelper.toMethodDescriptor("V", "F"), false));
            start = ASMHelper.find(haystackStart, needle);
            if (start == null || start.getNext() == null) {
                throw new RuntimeException("EntityPlayer.addExhaustion call pattern (index=" + patternIndex + ") not found in " + classNode.name + "." + method.name);
            }
            haystackStart = start.getNext();
        }
        this.patchAddExhaustionCall(method.instructions, start, start.getNext().getNext(), ((VarInsnNode)start).var, exhaustingActionEnum);
    }

    private void patchAddExhaustionCall(InsnList instructions, AbstractInsnNode loadPoint, AbstractInsnNode callPoint, int playerLoadIndex, String exhaustingAction) {
        VarInsnNode loadPlayer = new VarInsnNode(25, playerLoadIndex);
        instructions.insert(loadPoint, (AbstractInsnNode)loadPlayer);
        FieldInsnNode getEnum = new FieldInsnNode(178, ObfHelper.getInternalClassName("squeek.applecore.api.hunger.ExhaustionEvent$ExhaustingActions"), exhaustingAction, ASMHelper.toDescriptor("squeek.applecore.api.hunger.ExhaustionEvent$ExhaustingActions"));
        instructions.insert((AbstractInsnNode)loadPlayer, (AbstractInsnNode)getEnum);
        MethodInsnNode fireEvent = new MethodInsnNode(184, ASMConstants.HOOKS_INTERNAL_CLASS, "fireExhaustingActionEvent", ASMHelper.toMethodDescriptor("F", "net.minecraft.entity.player.EntityPlayer", "squeek.applecore.api.hunger.ExhaustionEvent$ExhaustingActions", "F"), false);
        instructions.insertBefore(callPoint, (AbstractInsnNode)fireEvent);
    }

    private void patchDamageEntity(MethodNode method) {
        AbstractInsnNode addExhaustionCall = this.getAddExhaustionCall(method);
        AbstractInsnNode loadPoint = addExhaustionCall.getPrevious().getPrevious().getPrevious();
        this.patchAddExhaustionCall(method.instructions, loadPoint, addExhaustionCall, 0, "DAMAGE_TAKEN");
    }

    private void patchMovementStat(MethodNode method, int callIndex, String exhaustingAction) {
        AbstractInsnNode addExhaustionCall = this.getAddExhaustionCall(method, callIndex);
        AbstractInsnNode loadPoint = ASMHelper.findPreviousInstructionWithOpcode(addExhaustionCall, 25);
        if (loadPoint == null) {
            throw new RuntimeException("No ALOAD found before addExhaustion call (index=" + callIndex + ") in EntityPlayer.addMovementStat");
        }
        this.patchAddExhaustionCall(method.instructions, loadPoint, addExhaustionCall, 0, exhaustingAction);
    }

    private AbstractInsnNode getAddExhaustionCall(MethodNode method) {
        return this.getAddExhaustionCall(method, 0);
    }

    private AbstractInsnNode getAddExhaustionCall(MethodNode method, int callIndex) {
        AbstractInsnNode addExhaustionCall = null;
        AbstractInsnNode haystackStart = method.instructions.getFirst();
        MethodInsnNode needle = new MethodInsnNode(182, ObfHelper.getInternalClassName("net.minecraft.entity.player.EntityPlayer"), ObfHelper.isObfuscated() ? "func_71020_j" : "addExhaustion", ASMHelper.toMethodDescriptor("V", "F"), false);
        for (int i = 0; i <= callIndex && haystackStart != null; ++i) {
            addExhaustionCall = ASMHelper.find(haystackStart, (AbstractInsnNode)needle);
            if (addExhaustionCall == null) {
                throw new RuntimeException("No addExhaustion call (index=" + callIndex + ") found in " + method.name + ":\n" + ASMHelper.getInsnListAsString(method.instructions));
            }
            haystackStart = addExhaustionCall.getNext();
        }
        return addExhaustionCall;
    }
}

