/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.threng.tile.base;

import io.github.phantamanta44.libnine.LibNine;
import io.github.phantamanta44.libnine.capability.impl.L9AspectSlot;
import io.github.phantamanta44.libnine.recipe.IRcp;
import io.github.phantamanta44.libnine.recipe.input.IRcpIn;
import io.github.phantamanta44.libnine.recipe.output.IRcpOut;
import io.github.phantamanta44.libnine.util.TriBool;
import io.github.phantamanta44.libnine.util.collection.Accrue;
import io.github.phantamanta44.libnine.util.data.serialization.AutoSerialize;
import io.github.phantamanta44.libnine.util.data.serialization.IDatum;
import io.github.phantamanta44.libnine.util.helper.InventoryUtils;
import io.github.phantamanta44.libnine.util.world.BlockSide;
import io.github.phantamanta44.libnine.util.world.IAllocableSides;
import io.github.phantamanta44.libnine.util.world.WorldUtils;
import io.github.phantamanta44.threng.tile.base.IAutoExporting;
import io.github.phantamanta44.threng.tile.base.IDroppableInventory;
import io.github.phantamanta44.threng.tile.base.TileMachine;
import io.github.phantamanta44.threng.util.AppEngUtils;
import io.github.phantamanta44.threng.util.SlotType;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class TileSimpleProcessor<IT, OT, I extends IRcpIn<IT>, O extends IRcpOut<OT>, R extends IRcp<IT, I, O>>
extends TileMachine
implements IAllocableSides<SlotType.BasicIO>,
IDroppableInventory,
IAutoExporting {
    private final Class<R> recipeType;
    @AutoSerialize(sync=false)
    private final L9AspectSlot slotUpgrade = new UpgradeSlot(this);
    @AutoSerialize
    private final IDatum.OfBool autoExporting = IDatum.ofBool((boolean)false);
    private TriBool canWork = TriBool.NONE;
    @Nullable
    private R activeRecipe = null;
    @Nullable
    private O activeRecipeOutput = null;
    private int maxWork = -1;
    private int energyCost = -1;

    public TileSimpleProcessor(Class<R> recipeType, int energyBuffer) {
        super(energyBuffer);
        this.recipeType = recipeType;
    }

    @Nullable
    public R getActiveRecipe() {
        return this.activeRecipe;
    }

    protected abstract IAllocableSides<SlotType.BasicIO> getSidedIo();

    public void setFace(BlockSide face, SlotType.BasicIO state) {
        this.getSidedIo().setFace(face, (Enum)state);
        this.setDirty();
    }

    public SlotType.BasicIO getFace(BlockSide face) {
        return (SlotType.BasicIO)this.getSidedIo().getFace(face);
    }

    @Override
    public boolean isAutoExporting() {
        return this.autoExporting.isTrue();
    }

    @Override
    public void setAutoExporting(boolean exporting) {
        if (this.autoExporting.isTrue() != exporting) {
            this.autoExporting.setBool(exporting);
            this.setDirty();
        }
    }

    @Override
    protected void tick() {
        super.tick();
        if (!this.field_145850_b.field_72995_K && this.autoExporting.isTrue() && this.field_145850_b.func_82737_E() % 16L == 0L) {
            this.doAutoExporting();
        }
    }

    private void doAutoExporting() {
        boolean somethingChanged = false;
        IItemHandlerModifiable outputs = this.getOutputInventory();
        if (outputs.getSlots() <= 0) {
            return;
        }
        int slotIndex = 0;
        while (outputs.getStackInSlot(slotIndex).func_190926_b()) {
            if (++slotIndex < outputs.getSlots()) continue;
            return;
        }
        EnumFacing front = this.getFrontFace();
        IAllocableSides<SlotType.BasicIO> sides = this.getSidedIo();
        for (BlockSide side : BlockSide.values()) {
            EnumFacing dir;
            TileEntity adjTile;
            if (!((SlotType.BasicIO)sides.getFace((BlockSide)side)).allowsOutput || (adjTile = WorldUtils.getAdjacentTile((TileEntity)this, (EnumFacing)(dir = side.getDirection(front)))) == null || !adjTile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d())) continue;
            ItemStack toExport = outputs.getStackInSlot(slotIndex);
            IItemHandler adjInv = (IItemHandler)Objects.requireNonNull(adjTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d()));
            ItemStack remaining = ItemHandlerHelper.insertItem((IItemHandler)adjInv, (ItemStack)toExport, (boolean)false);
            if (toExport.func_190916_E() == remaining.func_190916_E()) continue;
            outputs.setStackInSlot(slotIndex, remaining);
            somethingChanged = true;
            if (remaining.func_190926_b() && ++slotIndex >= outputs.getSlots()) break;
        }
        if (somethingChanged) {
            this.setDirty();
        }
    }

    @Override
    protected boolean canWork() {
        if (this.canWork == TriBool.NONE) {
            IT input = this.getInput();
            IRcp newRecipe = LibNine.PROXY.getRecipeManager().getRecipeList(this.recipeType).findRecipe(input);
            if (newRecipe != null) {
                if (newRecipe != this.activeRecipe) {
                    this.activeRecipe = newRecipe;
                    this.resetWork();
                }
                this.activeRecipeOutput = this.activeRecipe.mapToOutput(input);
                this.canWork = TriBool.wrap((boolean)this.activeRecipeOutput.isAcceptable(this.getOutputEnvironment()));
            } else {
                this.activeRecipe = null;
                this.canWork = TriBool.FALSE;
            }
        }
        return this.canWork.value;
    }

    @Override
    protected int getDeltaWork() {
        return 1;
    }

    @Override
    protected int getMaxWork() {
        if (this.maxWork == -1) {
            this.maxWork = this.getBaseMaxWork() - this.getUpgradeReducedWork();
        }
        return this.maxWork;
    }

    @Override
    protected int getEnergyCost() {
        if (this.energyCost == -1) {
            this.energyCost = (this.getBaseEnergyPerOperation() + this.getUpgradeEnergyCost()) / this.getMaxWork();
        }
        return this.energyCost;
    }

    protected int getUpgradeCount() {
        ItemStack stack = this.slotUpgrade.getStackInSlot();
        return stack.func_190926_b() ? 0 : stack.func_190916_E();
    }

    @Override
    protected void onWorkFinished() {
        this.acceptOutput(((IRcp)Objects.requireNonNull(this.activeRecipe)).input().consume(this.getInput()), (IRcpOut)Objects.requireNonNull(this.activeRecipeOutput));
    }

    protected void markWorkStateDirty() {
        this.canWork = TriBool.NONE;
    }

    protected abstract int getBaseEnergyPerOperation();

    protected abstract int getUpgradeEnergyCost();

    protected abstract int getBaseMaxWork();

    protected abstract int getUpgradeReducedWork();

    protected abstract IT getInput();

    protected abstract OT getOutputEnvironment();

    protected abstract void acceptOutput(IT var1, O var2);

    protected abstract IItemHandlerModifiable getOutputInventory();

    public L9AspectSlot getUpgradeSlot() {
        return this.slotUpgrade;
    }

    @Override
    public void collectDrops(Accrue<ItemStack> drops) {
        InventoryUtils.accrue(drops, (IItemHandler[])new IItemHandler[]{this.slotUpgrade});
    }

    private static class UpgradeSlot
    extends L9AspectSlot.Observable {
        UpgradeSlot(TileSimpleProcessor<?, ?, ?, ?, ?> tile) {
            super(AppEngUtils.IS_UPGRADE_ACCEL, (s, o, n) -> ((TileSimpleProcessor)tile).maxWork = (((TileSimpleProcessor)tile).energyCost = -1));
        }

        public int getSlotLimit() {
            return 8;
        }
    }
}

