/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.core.network;

import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.datastructure.MultitransformIterator;
import org.cyclops.integratedcrafting.api.crafting.CraftingJob;
import org.cyclops.integratedcrafting.api.crafting.CraftingJobDependencyGraph;
import org.cyclops.integratedcrafting.api.crafting.ICraftingInterface;
import org.cyclops.integratedcrafting.api.crafting.UnavailableCraftingInterfacesException;
import org.cyclops.integratedcrafting.api.network.ICraftingNetwork;
import org.cyclops.integratedcrafting.api.recipe.ICraftingJobIndexModifiable;
import org.cyclops.integratedcrafting.api.recipe.IRecipeIndexModifiable;
import org.cyclops.integratedcrafting.core.CraftingHelpers;
import org.cyclops.integratedcrafting.core.CraftingJobIndexDefault;
import org.cyclops.integratedcrafting.core.RecipeIndexDefault;

public class CraftingNetwork
implements ICraftingNetwork {
    private final Set<ICraftingInterface> allCraftingInterfaces = Sets.newHashSet();
    private final Int2ObjectMap<Set<ICraftingInterface>> craftingInterfaces = new Int2ObjectOpenHashMap();
    private final Multimap<IRecipeDefinition, ICraftingInterface> allRecipeCraftingInterfaces = CraftingNetwork.newRecipeCraftingInterfacesMap();
    private final Int2ObjectMap<Multimap<IRecipeDefinition, ICraftingInterface>> recipeCraftingInterfaces = new Int2ObjectOpenHashMap();
    private final IRecipeIndexModifiable allRecipesIndex = new RecipeIndexDefault();
    private final Int2ObjectMap<IRecipeIndexModifiable> recipeIndexes = new Int2ObjectOpenHashMap();
    private final ICraftingJobIndexModifiable allIndexedCraftingJobs = new CraftingJobIndexDefault();
    private final Int2ObjectMap<ICraftingJobIndexModifiable> indexedCraftingJobs = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<ICraftingInterface> allCraftingJobsToInterface = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<Int2ObjectMap<ICraftingInterface>> channeledCraftingJobsToInterface = new Int2ObjectOpenHashMap();
    private final CraftingJobDependencyGraph craftingJobDependencyGraph = new CraftingJobDependencyGraph();

    protected static Multimap<IRecipeDefinition, ICraftingInterface> newRecipeCraftingInterfacesMap() {
        return MultimapBuilder.hashKeys().treeSetValues(ICraftingInterface.createComparator()).build();
    }

    @Override
    public int[] getChannels() {
        return this.craftingInterfaces.keySet().toIntArray();
    }

    @Override
    public Set<ICraftingInterface> getCraftingInterfaces(int channel) {
        if (channel == -1) {
            return this.allCraftingInterfaces;
        }
        Set craftingInterfaces = (Set)this.craftingInterfaces.get(channel);
        if (craftingInterfaces == null) {
            craftingInterfaces = Sets.newTreeSet(ICraftingInterface.createComparator());
            this.craftingInterfaces.put(channel, (Object)craftingInterfaces);
        }
        return craftingInterfaces;
    }

    @Override
    public Multimap<IRecipeDefinition, ICraftingInterface> getRecipeCraftingInterfaces(int channel) {
        if (channel == -1) {
            return this.allRecipeCraftingInterfaces;
        }
        Multimap<IRecipeDefinition, ICraftingInterface> recipeCraftingInterfaces = (Multimap<IRecipeDefinition, ICraftingInterface>)this.recipeCraftingInterfaces.get(channel);
        if (recipeCraftingInterfaces == null) {
            recipeCraftingInterfaces = CraftingNetwork.newRecipeCraftingInterfacesMap();
            this.recipeCraftingInterfaces.put(channel, recipeCraftingInterfaces);
        }
        return recipeCraftingInterfaces;
    }

    @Override
    public IRecipeIndexModifiable getRecipeIndex(int channel) {
        if (channel == -1) {
            return this.allRecipesIndex;
        }
        IRecipeIndexModifiable recipeIndex = (IRecipeIndexModifiable)this.recipeIndexes.get(channel);
        if (recipeIndex == null) {
            recipeIndex = new RecipeIndexDefault();
            this.recipeIndexes.put(channel, (Object)recipeIndex);
        }
        return recipeIndex;
    }

    @Override
    public boolean addCraftingInterface(int channel, ICraftingInterface craftingInterface) {
        if (this.getCraftingInterfaces(channel).add(craftingInterface)) {
            this.allCraftingInterfaces.add(craftingInterface);
            IRecipeIndexModifiable recipeIndex = this.getRecipeIndex(channel);
            Multimap<IRecipeDefinition, ICraftingInterface> recipeCraftingInterfaces = this.getRecipeCraftingInterfaces(channel);
            for (IRecipeDefinition recipe : craftingInterface.getRecipes()) {
                recipeIndex.addRecipe(recipe);
                this.allRecipesIndex.addRecipe(recipe);
                recipeCraftingInterfaces.put((Object)recipe, (Object)craftingInterface);
                this.allRecipeCraftingInterfaces.put((Object)recipe, (Object)craftingInterface);
            }
            Iterator<CraftingJob> craftingJobsIt = craftingInterface.getCraftingJobs();
            while (craftingJobsIt.hasNext()) {
                CraftingJob craftingJob = craftingJobsIt.next();
                this.addCraftingJob(craftingJob.getChannel(), craftingJob, craftingInterface);
                this.craftingJobDependencyGraph.addCraftingJobId(craftingJob);
                IntListIterator dependencyIt = craftingJob.getDependencyCraftingJobs().iterator();
                while (dependencyIt.hasNext()) {
                    this.craftingJobDependencyGraph.addDependency(craftingJob, dependencyIt.nextInt());
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeCraftingInterface(int channel, ICraftingInterface craftingInterface) {
        if (this.getCraftingInterfaces(channel).remove(craftingInterface)) {
            this.allCraftingInterfaces.remove(craftingInterface);
            IRecipeIndexModifiable recipeIndex = this.getRecipeIndex(channel);
            Multimap<IRecipeDefinition, ICraftingInterface> recipeCraftingInterfaces = this.getRecipeCraftingInterfaces(channel);
            for (IRecipeDefinition recipe : craftingInterface.getRecipes()) {
                recipeCraftingInterfaces.remove((Object)recipe, (Object)craftingInterface);
                this.allRecipeCraftingInterfaces.remove((Object)recipe, (Object)craftingInterface);
                if (!recipeCraftingInterfaces.containsKey((Object)recipe)) {
                    recipeIndex.removeRecipe(recipe);
                }
                if (this.allRecipeCraftingInterfaces.containsKey((Object)recipe)) continue;
                this.allRecipesIndex.removeRecipe(recipe);
            }
            this.cleanupChannelIfEmpty(channel);
            Iterator<CraftingJob> craftingJobsIt = craftingInterface.getCraftingJobs();
            while (craftingJobsIt.hasNext()) {
                CraftingJob craftingJob = craftingJobsIt.next();
                this.removeCraftingJob(channel, craftingJob);
                this.craftingJobDependencyGraph.removeCraftingJobId(craftingJob);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addCraftingInterfaceRecipe(int channel, ICraftingInterface craftingInterface, IRecipeDefinition recipe) {
        IRecipeIndexModifiable recipeIndex = this.getRecipeIndex(channel);
        Multimap<IRecipeDefinition, ICraftingInterface> recipeCraftingInterfaces = this.getRecipeCraftingInterfaces(channel);
        recipeIndex.addRecipe(recipe);
        this.allRecipesIndex.addRecipe(recipe);
        boolean changed = recipeCraftingInterfaces.put((Object)recipe, (Object)craftingInterface);
        this.allRecipeCraftingInterfaces.put((Object)recipe, (Object)craftingInterface);
        return changed;
    }

    @Override
    public boolean removeCraftingInterfaceRecipe(int channel, ICraftingInterface craftingInterface, IRecipeDefinition recipe) {
        IRecipeIndexModifiable recipeIndex = this.getRecipeIndex(channel);
        Multimap<IRecipeDefinition, ICraftingInterface> recipeCraftingInterfaces = this.getRecipeCraftingInterfaces(channel);
        boolean changed = recipeCraftingInterfaces.remove((Object)recipe, (Object)craftingInterface);
        this.allRecipeCraftingInterfaces.remove((Object)recipe, (Object)craftingInterface);
        if (!recipeCraftingInterfaces.containsKey((Object)recipe)) {
            recipeIndex.removeRecipe(recipe);
        }
        if (!this.allRecipeCraftingInterfaces.containsKey((Object)recipe)) {
            this.allRecipesIndex.removeRecipe(recipe);
        }
        return changed;
    }

    @Override
    public void scheduleCraftingJob(CraftingJob craftingJob, boolean allowDistribution) throws UnavailableCraftingInterfacesException {
        Multimap<IRecipeDefinition, ICraftingInterface> recipeInterfaces = this.getRecipeCraftingInterfaces(craftingJob.getChannel());
        Collection craftingInterfaces = recipeInterfaces.get((Object)craftingJob.getRecipe()).stream().filter(ICraftingInterface::canScheduleCraftingJobs).collect(Collectors.toList());
        if (craftingInterfaces.size() == 0) {
            throw new UnavailableCraftingInterfacesException(craftingJob);
        }
        if (allowDistribution && craftingInterfaces.size() > 1 && craftingJob.getAmount() > 1) {
            List<CraftingJob> splitCraftingJobs = CraftingHelpers.splitCraftingJobs(craftingJob, craftingInterfaces.size(), this.getCraftingJobDependencyGraph(), CraftingHelpers.getGlobalCraftingJobIdentifier());
            for (CraftingJob splitCraftingJob : splitCraftingJobs) {
                this.scheduleCraftingJob(splitCraftingJob, false);
            }
            return;
        }
        int bestCraftingInterfaceJobCount = 0;
        ICraftingInterface bestCraftingInterface = null;
        for (ICraftingInterface craftingInterface : craftingInterfaces) {
            int jobCount = craftingInterface.getCraftingJobsCount();
            if (bestCraftingInterface != null && jobCount >= bestCraftingInterfaceJobCount) continue;
            bestCraftingInterfaceJobCount = jobCount;
            bestCraftingInterface = craftingInterface;
        }
        if (bestCraftingInterface != null) {
            bestCraftingInterface.scheduleCraftingJob(craftingJob);
            this.addCraftingJob(craftingJob.getChannel(), craftingJob, bestCraftingInterface);
            craftingJob.setStartTick(this.getCurrentTick());
        }
    }

    protected long getCurrentTick() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[0].func_82737_E();
    }

    @Override
    public void onCraftingJobFinished(CraftingJob craftingJob) {
        this.removeCraftingJob(craftingJob.getChannel(), craftingJob);
        this.getCraftingJobDependencyGraph().onCraftingJobFinished(craftingJob);
    }

    @Override
    public boolean cancelCraftingJob(int channel, int craftingJobId) {
        CraftingJob craftingJob = this.getCraftingJob(channel, craftingJobId);
        if (craftingJob != null) {
            this.cancelCraftingJob(craftingJob);
            return true;
        }
        return false;
    }

    protected void cancelCraftingJob(CraftingJob craftingJob) {
        for (CraftingJob dependency : this.getCraftingJobDependencyGraph().getDependencies(craftingJob)) {
            this.cancelCraftingJob(dependency);
        }
        ICraftingInterface craftingInterface = this.getCraftingJobInterface(craftingJob.getChannel(), craftingJob.getId());
        if (craftingInterface != null) {
            craftingInterface.cancelCraftingJob(craftingJob.getChannel(), craftingJob.getId());
        }
        this.onCraftingJobFinished(craftingJob);
    }

    @Override
    public Iterator<CraftingJob> getCraftingJobs(int channel) {
        return new MultitransformIterator(this.getCraftingInterfaces(channel).iterator(), ICraftingInterface::getCraftingJobs);
    }

    @Override
    @Nullable
    public CraftingJob getCraftingJob(int channel, int craftingJobId) {
        CraftingJob craftingJob;
        if (channel == -1) {
            return this.allIndexedCraftingJobs.getCraftingJob(craftingJobId);
        }
        ICraftingJobIndexModifiable index = (ICraftingJobIndexModifiable)this.indexedCraftingJobs.get(channel);
        if (index != null && (craftingJob = index.getCraftingJob(craftingJobId)) != null) {
            return craftingJob;
        }
        ICraftingJobIndexModifiable wildcardIndex = (ICraftingJobIndexModifiable)this.indexedCraftingJobs.get(-1);
        if (wildcardIndex != null) {
            return wildcardIndex.getCraftingJob(craftingJobId);
        }
        return null;
    }

    protected void addCraftingJob(int channel, CraftingJob craftingJob, ICraftingInterface craftingInterface) {
        Int2ObjectMap craftingJobsToInterface;
        ICraftingJobIndexModifiable craftingJobIndex = (ICraftingJobIndexModifiable)this.indexedCraftingJobs.get(channel);
        if (craftingJobIndex == null) {
            craftingJobIndex = new CraftingJobIndexDefault();
            this.indexedCraftingJobs.put(channel, (Object)craftingJobIndex);
        }
        if ((craftingJobsToInterface = (Int2ObjectMap)this.channeledCraftingJobsToInterface.get(channel)) == null) {
            craftingJobsToInterface = new Int2ObjectOpenHashMap();
            this.channeledCraftingJobsToInterface.put(channel, (Object)craftingJobsToInterface);
        }
        this.allIndexedCraftingJobs.addCraftingJob(craftingJob);
        craftingJobIndex.addCraftingJob(craftingJob);
        this.allCraftingJobsToInterface.put(craftingJob.getId(), (Object)craftingInterface);
        craftingJobsToInterface.put(craftingJob.getId(), (Object)craftingInterface);
    }

    protected void removeCraftingJob(int channel, CraftingJob craftingJob) {
        ICraftingJobIndexModifiable craftingJobIndex = (ICraftingJobIndexModifiable)this.indexedCraftingJobs.get(channel);
        Int2ObjectMap craftingJobsToInterface = (Int2ObjectMap)this.channeledCraftingJobsToInterface.get(channel);
        this.allIndexedCraftingJobs.removeCraftingJob(craftingJob);
        if (craftingJobIndex != null) {
            craftingJobIndex.removeCraftingJob(craftingJob);
        }
        this.allCraftingJobsToInterface.remove(craftingJob.getId());
        if (craftingJobsToInterface != null) {
            craftingJobsToInterface.remove(craftingJob.getId());
        }
    }

    @Override
    public <T, M> Iterator<CraftingJob> getCraftingJobs(int channel, IngredientComponent<T, M> ingredientComponent, T instance, M matchCondition) {
        if (channel == -1) {
            return this.allIndexedCraftingJobs.getCraftingJobs(ingredientComponent, instance, matchCondition);
        }
        ICraftingJobIndexModifiable craftingJobIndex = (ICraftingJobIndexModifiable)this.indexedCraftingJobs.get(channel);
        Object channelIterator = craftingJobIndex != null ? craftingJobIndex.getCraftingJobs(ingredientComponent, instance, matchCondition) : Iterators.forArray((Object[])new CraftingJob[0]);
        ICraftingJobIndexModifiable wildcardCraftingJobIndex = (ICraftingJobIndexModifiable)this.indexedCraftingJobs.get(-1);
        Object wildcardChannelIterator = wildcardCraftingJobIndex != null ? wildcardCraftingJobIndex.getCraftingJobs(ingredientComponent, instance, matchCondition) : Iterators.forArray((Object[])new CraftingJob[0]);
        return Iterators.concat((Iterator)channelIterator, (Iterator)wildcardChannelIterator);
    }

    @Override
    public CraftingJobDependencyGraph getCraftingJobDependencyGraph() {
        return this.craftingJobDependencyGraph;
    }

    @Override
    @Nullable
    public ICraftingInterface getCraftingJobInterface(int channel, int craftingJobId) {
        ICraftingInterface craftingInterface;
        if (channel == -1) {
            return (ICraftingInterface)this.allCraftingJobsToInterface.get(craftingJobId);
        }
        Int2ObjectMap craftingJobsToInterface = (Int2ObjectMap)this.channeledCraftingJobsToInterface.get(channel);
        if (craftingJobsToInterface != null && (craftingInterface = (ICraftingInterface)craftingJobsToInterface.get(craftingJobId)) != null) {
            return craftingInterface;
        }
        Int2ObjectMap craftingJobsToInterfaceWildcard = (Int2ObjectMap)this.channeledCraftingJobsToInterface.get(-1);
        if (craftingJobsToInterfaceWildcard != null) {
            return (ICraftingInterface)craftingJobsToInterfaceWildcard.get(craftingJobId);
        }
        return null;
    }

    @Override
    public long getRunningTicks(CraftingJob craftingJob) {
        return this.getCurrentTick() - craftingJob.getStartTick();
    }

    protected void cleanupChannelIfEmpty(int channel) {
        Set craftingInterfaces = (Set)this.craftingInterfaces.get(channel);
        if (craftingInterfaces != null && craftingInterfaces.isEmpty()) {
            this.craftingInterfaces.remove(channel);
            this.recipeIndexes.remove(channel);
            this.recipeCraftingInterfaces.remove(channel);
        }
    }
}

