/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.core.crafting.processoverride;

import com.mojang.authlib.GameProfile;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.integratedcrafting.api.crafting.ICraftingProcessOverride;
import org.cyclops.integratedcrafting.api.crafting.ICraftingResultsSink;
import org.cyclops.integratedcrafting.core.crafting.processoverride.CraftingGrid;
import org.cyclops.integrateddynamics.api.part.PartPos;

public class CraftingProcessOverrideCraftingTable
implements ICraftingProcessOverride {
    private static GameProfile PROFILE = new GameProfile(UUID.fromString("41C82C87-7AfB-4024-BB57-13D2C99CAE77"), "[IntegratedCrafting]");
    private static final Map<WorldServer, FakePlayer> FAKE_PLAYERS = new WeakHashMap<WorldServer, FakePlayer>();

    public static FakePlayer getFakePlayer(WorldServer world) {
        FakePlayer fakePlayer = FAKE_PLAYERS.get(world);
        if (fakePlayer == null) {
            fakePlayer = new FakePlayer(world, PROFILE);
            FAKE_PLAYERS.put(world, fakePlayer);
        }
        return fakePlayer;
    }

    @Override
    public boolean isApplicable(PartPos target) {
        return target.getPos().getWorld().func_180495_p(target.getPos().getBlockPos()).func_177230_c() instanceof BlockWorkbench;
    }

    @Override
    public boolean craft(Function<IngredientComponent<?, ?>, PartPos> targetGetter, IMixedIngredients ingredients, ICraftingResultsSink resultsSink, boolean simulate) {
        CraftingGrid grid = new CraftingGrid(ingredients, 3, 3);
        PartPos target = targetGetter.apply(IngredientComponent.ITEMSTACK);
        IRecipe recipe = CraftingHelpers.findMatchingRecipeCached((InventoryCrafting)grid, (World)target.getPos().getWorld(), (boolean)true);
        if (recipe != null) {
            ItemStack result = recipe.func_77572_b((InventoryCrafting)grid);
            if (result.func_190926_b()) {
                return false;
            }
            if (!simulate) {
                FakePlayer player = CraftingProcessOverrideCraftingTable.getFakePlayer((WorldServer)target.getPos().getWorld());
                result.func_77980_a(target.getPos().getWorld(), (EntityPlayer)player, 1);
                FMLCommonHandler.instance().firePlayerCraftingEvent((EntityPlayer)player, result, (IInventory)grid);
                resultsSink.addResult(IngredientComponent.ITEMSTACK, result);
                for (ItemStack remainingItem : recipe.func_179532_b((InventoryCrafting)grid)) {
                    if (remainingItem.func_190926_b()) continue;
                    resultsSink.addResult(IngredientComponent.ITEMSTACK, remainingItem);
                }
            }
            return true;
        }
        return false;
    }
}

