/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;

public class MissingIngredients<T, M> {
    private final List<Element<T, M>> elements;

    public MissingIngredients(List<Element<T, M>> elements) {
        this.elements = elements;
    }

    public List<Element<T, M>> getElements() {
        return this.elements;
    }

    public boolean equals(Object obj) {
        return obj instanceof MissingIngredients && this.getElements().equals(((MissingIngredients)obj).getElements());
    }

    public String toString() {
        return this.getElements().toString();
    }

    public static NBTTagCompound serialize(Map<IngredientComponent<?, ?>, MissingIngredients<?, ?>> ingredients) {
        NBTTagCompound tag = new NBTTagCompound();
        for (Map.Entry<IngredientComponent<?, ?>, MissingIngredients<?, ?>> entry : ingredients.entrySet()) {
            NBTTagList missingIngredientsTag = new NBTTagList();
            for (Element<?, ?> element : entry.getValue().getElements()) {
                NBTTagList elementsTag = new NBTTagList();
                for (PrototypedWithRequested<?, ?> alternative : element.getAlternatives()) {
                    NBTTagCompound alternativeTag = new NBTTagCompound();
                    alternativeTag.func_74782_a("requestedPrototype", (NBTBase)IPrototypedIngredient.serialize(alternative.getRequestedPrototype()));
                    alternativeTag.func_74772_a("quantityMissing", alternative.getQuantityMissing());
                    elementsTag.func_74742_a((NBTBase)alternativeTag);
                }
                missingIngredientsTag.func_74742_a((NBTBase)elementsTag);
            }
            tag.func_74782_a(entry.getKey().getName().toString(), (NBTBase)missingIngredientsTag);
        }
        return tag;
    }

    public static Map<IngredientComponent<?, ?>, MissingIngredients<?, ?>> deserialize(NBTTagCompound tag) throws IllegalArgumentException {
        IdentityHashMap map = Maps.newIdentityHashMap();
        for (String componentName : tag.func_150296_c()) {
            IngredientComponent component = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation(componentName));
            if (component == null) {
                throw new IllegalArgumentException("Could not find the ingredient component type " + componentName);
            }
            ArrayList elements = Lists.newArrayList();
            NBTTagList missingIngredientsTag = tag.func_150295_c(componentName, 9);
            for (int i = 0; i < missingIngredientsTag.func_74745_c(); ++i) {
                NBTTagList elementsTag = (NBTTagList)missingIngredientsTag.func_179238_g(i);
                ArrayList alternatives = Lists.newArrayList();
                for (int j = 0; j < elementsTag.func_74745_c(); ++j) {
                    NBTTagCompound alternativeTag = elementsTag.func_150305_b(j);
                    PrototypedIngredient requestedPrototype = IPrototypedIngredient.deserialize((NBTTagCompound)alternativeTag.func_74775_l("requestedPrototype"));
                    long quantityMissing = alternativeTag.func_74763_f("quantityMissing");
                    alternatives.add(new PrototypedWithRequested(requestedPrototype, quantityMissing));
                }
                elements.add(new Element(alternatives));
            }
            MissingIngredients missingIngredients = new MissingIngredients(elements);
            map.put(component, missingIngredients);
        }
        return map;
    }

    public static class PrototypedWithRequested<T, M> {
        private final IPrototypedIngredient<T, M> requestedPrototype;
        private final long quantityMissing;

        public PrototypedWithRequested(IPrototypedIngredient<T, M> requestedPrototype, long quantityMissing) {
            this.requestedPrototype = requestedPrototype;
            this.quantityMissing = quantityMissing;
        }

        public IPrototypedIngredient<T, M> getRequestedPrototype() {
            return this.requestedPrototype;
        }

        public long getQuantityMissing() {
            return this.quantityMissing;
        }

        public boolean equals(Object obj) {
            return obj instanceof PrototypedWithRequested && this.getRequestedPrototype().equals(((PrototypedWithRequested)obj).getRequestedPrototype()) && this.getQuantityMissing() == ((PrototypedWithRequested)obj).getQuantityMissing();
        }

        public String toString() {
            return String.format("[Prototype: %s; missing: %s]", this.getRequestedPrototype(), this.getQuantityMissing());
        }
    }

    public static class Element<T, M> {
        private final List<PrototypedWithRequested<T, M>> alternatives;

        public Element(List<PrototypedWithRequested<T, M>> alternatives) {
            this.alternatives = alternatives;
        }

        public List<PrototypedWithRequested<T, M>> getAlternatives() {
            return this.alternatives;
        }

        public boolean equals(Object obj) {
            return obj instanceof Element && this.getAlternatives().equals(((Element)obj).getAlternatives());
        }

        public String toString() {
            return this.getAlternatives().toString();
        }
    }
}

