/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.client.gui;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.client.gui.component.input.GuiArrowedListField;
import org.cyclops.cyclopscore.client.gui.component.input.GuiNumberField;
import org.cyclops.cyclopscore.client.gui.component.input.IInputListener;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.integratedcrafting.IntegratedCrafting;
import org.cyclops.integratedcrafting.inventory.container.ContainerPartInterfaceCraftingSettings;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.client.gui.GuiTextFieldDropdown;
import org.cyclops.integrateddynamics.core.client.gui.IDropdownEntry;
import org.cyclops.integrateddynamics.core.client.gui.container.GuiPartSettings;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerPartSettings;

public class GuiPartInterfaceCraftingSettings
extends GuiPartSettings
implements IInputListener {
    private GuiArrowedListField<IngredientComponent<?, ?>> ingredientComponentSideSelector = null;
    private GuiTextFieldDropdown<EnumFacing> dropdownFieldSide = null;
    private List<GuiPartSettings.SideDropdownEntry> dropdownEntries;
    private IngredientComponent<?, ?> selectedIngredientComponent = null;
    private GuiNumberField numberFieldChannelInterfaceCrafting = null;

    public GuiPartInterfaceCraftingSettings(EntityPlayer player, PartTarget target, IPartContainer partContainer, IPartType partType) {
        super((ContainerPartSettings)new ContainerPartInterfaceCraftingSettings(player, target, partContainer, partType), player, target, partContainer, partType);
    }

    protected ResourceLocation constructResourceLocation() {
        return new ResourceLocation("integratedcrafting", this.getGuiTexture());
    }

    public String getGuiTexture() {
        return (String)IntegratedCrafting._instance.getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_GUI) + "part_interface_settings.png";
    }

    protected boolean isFieldSideEnabled() {
        return false;
    }

    protected int getFieldUpdateIntervalY() {
        return 59;
    }

    protected int getFieldPriorityY() {
        return 84;
    }

    protected int getFieldChannelY() {
        return 109;
    }

    protected void onSave() {
        super.onSave();
        try {
            EnumFacing selectedSide = this.dropdownFieldSide.getSelectedDropdownPossibility() == null ? null : (EnumFacing)this.dropdownFieldSide.getSelectedDropdownPossibility().getValue();
            int side = selectedSide != null && selectedSide != this.getDefaultSide() ? selectedSide.ordinal() : -1;
            ValueNotifierHelpers.setValue((IValueNotifier)this.getContainer(), (int)((ContainerPartInterfaceCraftingSettings)this.getContainer()).getTargetSideOverrideValueId(this.selectedIngredientComponent), (int)side);
            int channelInterface = this.numberFieldChannelInterfaceCrafting.getInt();
            ValueNotifierHelpers.setValue((IValueNotifier)this.getContainer(), (int)((ContainerPartInterfaceCraftingSettings)this.getContainer()).getLastChannelInterfaceCraftingValueId(), (int)channelInterface);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.ingredientComponentSideSelector = new GuiArrowedListField<IngredientComponent<?, ?>>(0, Minecraft.func_71410_x().field_71466_p, this.field_147003_i + 106, this.field_147009_r + 9, 68, 15, true, true, IngredientComponent.REGISTRY.getValues()){

            protected String activeElementToString(IngredientComponent<?, ?> element) {
                return L10NHelpers.localize((String)element.getTranslationKey(), (Object[])new Object[0]);
            }
        };
        this.ingredientComponentSideSelector.setListener((IInputListener)this);
        this.selectedIngredientComponent = (IngredientComponent)this.ingredientComponentSideSelector.getActiveElement();
        this.dropdownEntries = Arrays.stream(EnumFacing.field_82609_l).map(x$0 -> new GuiPartSettings.SideDropdownEntry((GuiPartSettings)this, x$0)).collect(Collectors.toList());
        this.dropdownFieldSide = new GuiTextFieldDropdown(0, Minecraft.func_71410_x().field_71466_p, this.field_147003_i + 106, this.field_147009_r + 34, 68, 14, true, (Set)Sets.newHashSet(this.dropdownEntries));
        this.setSideInDropdownField(this.selectedIngredientComponent, ((ContainerPartInterfaceCraftingSettings)this.container).getTargetSideOverrideValue(this.selectedIngredientComponent));
        this.dropdownFieldSide.func_146203_f(15);
        this.dropdownFieldSide.func_146189_e(true);
        this.dropdownFieldSide.func_146193_g(0xFFFFFF);
        this.dropdownFieldSide.func_146205_d(true);
        this.numberFieldChannelInterfaceCrafting = new GuiNumberField(0, Minecraft.func_71410_x().field_71466_p, this.field_147003_i + 106, this.field_147009_r + 134, 70, 14, true, true);
        this.numberFieldChannelInterfaceCrafting.setPositiveOnly(false);
        this.numberFieldChannelInterfaceCrafting.func_146203_f(15);
        this.numberFieldChannelInterfaceCrafting.func_146189_e(true);
        this.numberFieldChannelInterfaceCrafting.func_146193_g(0xFFFFFF);
        this.numberFieldChannelInterfaceCrafting.func_146205_d(true);
        this.refreshValues();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!(this.func_146983_a(keyCode) || this.numberFieldChannelInterfaceCrafting.func_146201_a(typedChar, keyCode) || this.dropdownFieldSide.func_146201_a(typedChar, keyCode))) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.ingredientComponentSideSelector.func_146192_a(mouseX, mouseY, mouseButton);
        this.dropdownFieldSide.func_146192_a(mouseX, mouseY, mouseButton);
        this.numberFieldChannelInterfaceCrafting.func_146192_a(mouseX, mouseY, mouseButton);
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.field_146289_q.func_78276_b(L10NHelpers.localize((String)"gui.integrateddynamics.partsettings.side", (Object[])new Object[0]), this.field_147003_i + 8, this.field_147009_r + 12, Helpers.RGBToInt((int)0, (int)0, (int)0));
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.ingredientComponentSideSelector.drawTextBox(Minecraft.func_71410_x(), mouseX, mouseY);
        this.dropdownFieldSide.drawTextBox(Minecraft.func_71410_x(), mouseX, mouseY);
        this.field_146289_q.func_78276_b(L10NHelpers.localize((String)"gui.integratedcrafting.partsettings.channel.interface", (Object[])new Object[0]), this.field_147003_i + 8, this.field_147009_r + 137, 0);
        this.numberFieldChannelInterfaceCrafting.drawTextBox(Minecraft.func_71410_x(), mouseX, mouseY);
    }

    protected int getBaseYSize() {
        return 236;
    }

    protected void setSideInDropdownField(IngredientComponent<?, ?> ingredientComponent, EnumFacing side) {
        if (this.selectedIngredientComponent == ingredientComponent) {
            this.dropdownFieldSide.selectPossibility((IDropdownEntry)this.dropdownEntries.get(side.ordinal()));
        }
    }

    public void onUpdate(int valueId, NBTTagCompound value) {
        super.onUpdate(valueId, value);
        for (IngredientComponent ingredientComponent : IngredientComponent.REGISTRY.getValuesCollection()) {
            if (valueId != ((ContainerPartInterfaceCraftingSettings)this.getContainer()).getTargetSideOverrideValueId(ingredientComponent)) continue;
            int side = ((ContainerPartInterfaceCraftingSettings)this.getContainer()).getTargetSideOverrideValue(ingredientComponent).ordinal();
            this.setSideInDropdownField(ingredientComponent, side == -1 ? this.getDefaultSide() : EnumFacing.field_82609_l[side]);
        }
        if (valueId == ((ContainerPartInterfaceCraftingSettings)this.getContainer()).getLastChannelInterfaceCraftingValueId()) {
            this.numberFieldChannelInterfaceCrafting.func_146180_a(Integer.toString(((ContainerPartInterfaceCraftingSettings)this.getContainer()).getLastChannelInterfaceValue()));
        }
    }

    public void onChanged() {
        this.onSave();
        this.selectedIngredientComponent = (IngredientComponent)this.ingredientComponentSideSelector.getActiveElement();
        this.setSideInDropdownField(this.selectedIngredientComponent, ((ContainerPartInterfaceCraftingSettings)this.container).getTargetSideOverrideValue(this.selectedIngredientComponent));
    }
}

