/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.shapes;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.thirteen.Context;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketUpdateNBTShapeCard
implements IMessage {
    private TypedMap args;

    public void fromBytes(ByteBuf buf) {
        this.args = TypedMapTools.readArguments((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        TypedMapTools.writeArguments((ByteBuf)buf, (TypedMap)this.args);
    }

    public PacketUpdateNBTShapeCard() {
    }

    public PacketUpdateNBTShapeCard(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketUpdateNBTShapeCard(TypedMap arguments) {
        this.args = arguments;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            EntityPlayerMP playerEntity = ctx.getSender();
            ItemStack heldItem = playerEntity.func_184586_b(EnumHand.MAIN_HAND);
            if (heldItem.func_190926_b()) {
                return;
            }
            NBTTagCompound tagCompound = heldItem.func_77978_p();
            if (tagCompound == null) {
                tagCompound = new NBTTagCompound();
                heldItem.func_77982_d(tagCompound);
            }
            for (Key akey : this.args.getKeys()) {
                String key = akey.getName();
                if (Type.STRING.equals(akey.getType())) {
                    tagCompound.func_74778_a(key, (String)this.args.get(akey));
                    continue;
                }
                if (Type.INTEGER.equals(akey.getType())) {
                    tagCompound.func_74768_a(key, ((Integer)this.args.get(akey)).intValue());
                    continue;
                }
                if (Type.DOUBLE.equals(akey.getType())) {
                    tagCompound.func_74780_a(key, ((Double)this.args.get(akey)).doubleValue());
                    continue;
                }
                if (Type.BOOLEAN.equals(akey.getType())) {
                    tagCompound.func_74757_a(key, ((Boolean)this.args.get(akey)).booleanValue());
                    continue;
                }
                if (Type.BLOCKPOS.equals(akey.getType())) {
                    throw new RuntimeException("BlockPos not supported for PacketUpdateNBTItem!");
                }
                if (!Type.ITEMSTACK.equals(akey.getType())) continue;
                throw new RuntimeException("ItemStack not supported for PacketUpdateNBTItem!");
            }
        });
        ctx.setPacketHandled(true);
    }
}

