/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.storage;

import java.awt.Rectangle;
import mcjty.lib.base.ModBase;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.rftools.RFTools;
import mcjty.rftools.items.storage.PacketUpdateNBTItemFilter;
import mcjty.rftools.items.storage.StorageFilterContainer;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.setup.GuiProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiStorageFilter
extends GenericGuiContainer<GenericTileEntity> {
    public static final int CONTROLLER_WIDTH = 180;
    public static final int CONTROLLER_HEIGHT = 188;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/storagefilter.png");
    private static final ResourceLocation guiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");
    private ImageChoiceLabel blacklistMode;
    private ImageChoiceLabel oredictMode;
    private ImageChoiceLabel damageMode;
    private ImageChoiceLabel nbtMode;
    private ImageChoiceLabel modMode;

    public GuiStorageFilter(StorageFilterContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, null, (Container)container, GuiProxy.GUI_MANUAL_MAIN, "storfilter");
        this.field_146999_f = 180;
        this.field_147000_g = 188;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.blacklistMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint(130, 9, 16, 16)).setTooltips(new String[]{"Black or whitelist mode"})).addChoiceEvent((parent, newChoice) -> this.updateSettings());
        this.blacklistMode.addChoice("Black", "Blacklist items", guiElements, 224, 32);
        this.blacklistMode.addChoice("White", "Whitelist items", guiElements, 240, 32);
        this.oredictMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint(148, 9, 16, 16)).setTooltips(new String[]{"Filter based on ore dictionary"})).addChoiceEvent((parent, newChoice) -> this.updateSettings());
        this.oredictMode.addChoice("Off", "Oredict matching off", guiElements, 160, 32);
        this.oredictMode.addChoice("On", "Oredict matching on", guiElements, 176, 32);
        this.damageMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint(130, 27, 16, 16)).setTooltips(new String[]{"Filter ignoring damage"})).addChoiceEvent((parent, newChoice) -> this.updateSettings());
        this.damageMode.addChoice("Off", "Ignore damage", guiElements, 96, 32);
        this.damageMode.addChoice("On", "Damage must match", guiElements, 112, 32);
        this.nbtMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint(148, 27, 16, 16)).setTooltips(new String[]{"Filter ignoring NBT"})).addChoiceEvent((parent, newChoice) -> this.updateSettings());
        this.nbtMode.addChoice("Off", "Ignore NBT", guiElements, 128, 32);
        this.nbtMode.addChoice("On", "NBT must match", guiElements, 144, 32);
        this.modMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint(130, 45, 16, 16)).setTooltips(new String[]{"Filter ignoring mod"})).addChoiceEvent((parent, newChoice) -> this.updateSettings());
        this.modMode.addChoice("Off", "Don't match on mod", guiElements, 192, 32);
        this.modMode.addChoice("On", "Only mod must match", guiElements, 208, 32);
        NBTTagCompound tagCompound = Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.MAIN_HAND).func_77978_p();
        if (tagCompound != null) {
            this.setBlacklistMode(tagCompound.func_74779_i("blacklistMode"));
            this.oredictMode.setCurrentChoice(tagCompound.func_74767_n("oredictMode") ? 1 : 0);
            this.damageMode.setCurrentChoice(tagCompound.func_74767_n("damageMode") ? 1 : 0);
            this.nbtMode.setCurrentChoice(tagCompound.func_74767_n("nbtMode") ? 1 : 0);
            this.modMode.setCurrentChoice(tagCompound.func_74767_n("modMode") ? 1 : 0);
        }
        Panel toplevel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setBackground(iconLocation)).addChildren(new Widget[]{this.blacklistMode, this.oredictMode, this.damageMode, this.nbtMode, this.modMode});
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
    }

    private void setBlacklistMode(String mode) {
        int idx = this.blacklistMode.findChoice(mode);
        if (idx == -1) {
            this.blacklistMode.setCurrentChoice("Black");
        } else {
            this.blacklistMode.setCurrentChoice(idx);
        }
    }

    private void updateSettings() {
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketUpdateNBTItemFilter(TypedMap.builder().put(new Key("blacklistMode", Type.STRING), (Object)this.blacklistMode.getCurrentChoice()).put(new Key("oredictMode", Type.BOOLEAN), (Object)(this.oredictMode.getCurrentChoiceIndex() == 1 ? 1 : 0)).put(new Key("damageMode", Type.BOOLEAN), (Object)(this.damageMode.getCurrentChoiceIndex() == 1 ? 1 : 0)).put(new Key("modMode", Type.BOOLEAN), (Object)(this.modMode.getCurrentChoiceIndex() == 1 ? 1 : 0)).put(new Key("nbtMode", Type.BOOLEAN), (Object)(this.nbtMode.getCurrentChoiceIndex() == 1 ? 1 : 0)).build()));
    }
}

