/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.modifier;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.thirteen.Context;
import mcjty.rftools.items.ModItems;
import mcjty.rftools.items.modifier.ModifierCommand;
import mcjty.rftools.items.modifier.ModifierFilterOperation;
import mcjty.rftools.items.modifier.ModifierFilterType;
import mcjty.rftools.items.modifier.ModifierItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketUpdateModifier
implements IMessage {
    private ModifierCommand cmd = ModifierCommand.ADD;
    private int index;
    private ModifierFilterType type;
    private ModifierFilterOperation op;

    public void fromBytes(ByteBuf buf) {
        this.cmd = ModifierCommand.values()[buf.readByte()];
        this.index = buf.readInt();
        this.type = ModifierFilterType.values()[buf.readByte()];
        this.op = ModifierFilterOperation.values()[buf.readByte()];
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.cmd == null ? 0 : this.cmd.ordinal());
        buf.writeInt(this.index);
        buf.writeByte(this.type == null ? 0 : this.type.ordinal());
        buf.writeByte(this.op == null ? 0 : this.op.ordinal());
    }

    public PacketUpdateModifier() {
    }

    public PacketUpdateModifier(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketUpdateModifier(ModifierCommand cmd, int index, ModifierFilterType type, ModifierFilterOperation op) {
        this.cmd = cmd;
        this.index = index;
        this.type = type;
        this.op = op;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            EntityPlayerMP player = ctx.getSender();
            ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
            if (!heldItem.func_190926_b() && heldItem.func_77973_b() == ModItems.modifierItem) {
                ModifierItem.performCommand((EntityPlayer)player, heldItem, this.cmd, this.index, this.type, this.op);
            }
        });
        ctx.setPacketHandled(true);
    }
}

