/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autoconfig.factory;

import info.loenwind.autoconfig.factory.AbstractValue;
import info.loenwind.autoconfig.factory.ByteBufAdapters;
import info.loenwind.autoconfig.factory.IByteBufAdapter;
import info.loenwind.autoconfig.factory.IValueFactory;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.Property;

class LimitedStringValue
extends AbstractValue<String> {
    private final String[] limit;

    protected LimitedStringValue(IValueFactory owner, String section, String keyname, String defaultValue, String[] limit, String text) {
        super(owner, section, keyname, defaultValue, text);
        this.limit = limit;
    }

    @Override
    @Nullable
    protected String makeValue() {
        Property prop = this.owner.getConfig().get(this.section, this.keyname, (String)this.defaultValue);
        prop.setValidValues(this.limit);
        prop.setLanguageKey(this.keyname);
        prop.setComment(this.getText() + " [default: " + (String)this.defaultValue + "]");
        prop.setRequiresMcRestart(this.isStartup);
        return prop.getString();
    }

    @Override
    protected IByteBufAdapter<String> getDataType() {
        return ByteBufAdapters.STRING127;
    }
}

