/*
 * Decompiled with CFR 0.152.
 */
package tterrag.treesimulator;

import com.google.common.base.Throwables;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import tterrag.treesimulator.MessageBonemealParticles;
import tterrag.treesimulator.MessagePlayerParticle;
import tterrag.treesimulator.PacketHandlerTGS;
import tterrag.treesimulator.TreeSimulator;

public class TickHandlerTGS {
    private Map<String, Integer> counters = new HashMap<String, Integer>();
    private Map<String, PlayerState> states = new HashMap<String, PlayerState>();
    private int ticksSinceLastCheck = 0;
    private Constructor<BonemealEvent> eventctor;

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        int movementCounter;
        Integer temp = this.counters.get(event.player.func_174793_f().func_70005_c_());
        int n = movementCounter = temp == null ? 0 : temp;
        if (event.phase == TickEvent.Phase.END && !event.player.func_130014_f_().field_72995_K) {
            EntityPlayer player = event.player;
            if (this.ticksSinceLastCheck >= 5) {
                List<BlockPos> coords = this.getNearestBlocks(player.func_130014_f_(), new BlockPos((Entity)player));
                if (coords.size() == 0) {
                    return;
                }
                if (player.func_70051_ag()) {
                    ++movementCounter;
                    this.sendPlayerPacket(player, coords);
                    this.doEngines(coords, player.func_130014_f_());
                }
                if (PlayerState.getState(player.func_70093_af()) != this.getState(player)) {
                    ++movementCounter;
                    this.sendPlayerPacket(player, coords);
                    this.doEngines(coords, player.func_130014_f_());
                }
                if (movementCounter > TreeSimulator.waitTime) {
                    if (coords.size() == 0) {
                        --movementCounter;
                        return;
                    }
                    Collections.shuffle(coords);
                    for (BlockPos pos : coords) {
                        BonemealEvent bonemeal;
                        Block block = player.func_130014_f_().func_180495_p(pos).func_177230_c();
                        if (!(block instanceof BlockSapling)) continue;
                        try {
                            bonemeal = new BonemealEvent(player, player.func_130014_f_(), pos, player.func_130014_f_().func_180495_p(pos));
                        }
                        catch (Throwable t) {
                            try {
                                if (this.eventctor == null) {
                                    this.eventctor = BonemealEvent.class.getConstructor(EntityPlayer.class, World.class, BlockPos.class, IBlockState.class, EnumHand.class, ItemStack.class);
                                }
                                bonemeal = this.eventctor.newInstance(player, player.func_130014_f_(), pos, player.func_130014_f_().func_180495_p(pos), EnumHand.MAIN_HAND, new ItemStack(Blocks.field_150350_a, 0));
                            }
                            catch (Exception e) {
                                throw Throwables.propagate((Throwable)e);
                            }
                        }
                        MinecraftForge.EVENT_BUS.post((Event)bonemeal);
                        BlockSapling sapling = (BlockSapling)block;
                        if ((double)player.func_130014_f_().field_73012_v.nextFloat() < 0.45) {
                            sapling.func_176476_e(player.func_130014_f_(), pos, player.func_130014_f_().func_180495_p(pos), player.func_130014_f_().field_73012_v);
                        }
                        if (!TreeSimulator.showParticles || sapling != Blocks.field_150345_g) break;
                        this.sendBonemealPacket(pos);
                        break;
                    }
                    movementCounter = 0;
                }
            } else {
                ++this.ticksSinceLastCheck;
            }
            this.states.put(player.func_174793_f().func_70005_c_(), PlayerState.getState(player.func_70093_af()));
            this.counters.put(event.player.func_174793_f().func_70005_c_(), movementCounter);
        }
    }

    private PlayerState getState(EntityPlayer player) {
        String user = player.func_174793_f().func_70005_c_();
        if (!this.states.containsKey(user)) {
            this.states.put(user, PlayerState.getState(player.func_70093_af()));
        }
        return this.states.get(user);
    }

    @Deprecated
    private void doEngines(List<BlockPos> coords, World world) {
        for (BlockPos pos : coords) {
            Block block = world.func_180495_p(pos).func_177230_c();
        }
    }

    private void sendBonemealPacket(BlockPos pos) {
        PacketHandlerTGS.INSTANCE.sendToAll((IMessage)new MessageBonemealParticles(pos));
    }

    private void sendPlayerPacket(EntityPlayer player, List<BlockPos> coords) {
        if (TreeSimulator.allTheParticles) {
            for (BlockPos pos : coords) {
                PacketHandlerTGS.INSTANCE.sendToDimension((IMessage)new MessagePlayerParticle(player, pos), player.field_70170_p.field_73011_w.getDimension());
            }
        } else {
            BlockPos blockPos = coords.get(player.func_130014_f_().field_73012_v.nextInt(coords.size()));
        }
    }

    private List<BlockPos> getNearestBlocks(World world, BlockPos pos) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (BlockPos p : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-5, -2, -5), (BlockPos)pos.func_177982_a(5, 2, 5))) {
            Block block = world.func_180495_p(p).func_177230_c();
            if (!(block instanceof BlockSapling)) continue;
            list.add(p);
        }
        return list;
    }

    public static enum PlayerState {
        CROUCHED,
        STANDING;


        public static PlayerState getState(boolean bool) {
            return bool ? CROUCHED : STANDING;
        }
    }
}

