/*
 * Decompiled with CFR 0.152.
 */
package tterrag.treesimulator;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import tterrag.treesimulator.MessageBonemealParticles;

public class MessagePlayerParticle
extends MessageBonemealParticles {
    private int playerID;

    public MessagePlayerParticle() {
    }

    public MessagePlayerParticle(@Nonnull EntityPlayer player, @Nonnull BlockPos pos) {
        super(pos);
        this.playerID = player.func_145782_y();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.playerID);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.playerID = buf.readInt();
    }

    public static final class Handler
    implements IMessageHandler<MessagePlayerParticle, IMessage> {
        public IMessage onMessage(final MessagePlayerParticle message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityPlayer player = (EntityPlayer)Minecraft.func_71410_x().field_71441_e.func_73045_a(message.playerID);
                    if (player == null) {
                        return;
                    }
                    World world = player.field_70170_p;
                    Vec3d spawnPos = new Vec3d(player.field_70165_t + (world.field_73012_v.nextGaussian() - 0.5) * 0.5, player.field_70163_u + (world.field_73012_v.nextGaussian() - 0.5) * 0.8, player.field_70161_v + (world.field_73012_v.nextGaussian() - 0.5) * 0.5);
                    Vec3d endPos = new Vec3d((Vec3i)message.pos).func_72441_c(0.5, 0.5, 0.5);
                    Vec3d vel = spawnPos.func_178788_d(endPos).func_186678_a(-0.02);
                    Particle p = Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.VILLAGER_HAPPY.func_179348_c(), spawnPos.field_72450_a, spawnPos.field_72448_b, spawnPos.field_72449_c, vel.field_72450_a, vel.field_72448_b, vel.field_72449_c, new int[0]);
                    p.field_187129_i = vel.field_72450_a;
                    p.field_187130_j = vel.field_72448_b;
                    p.field_187131_k = vel.field_72449_c;
                }
            });
            return null;
        }
    }
}

