/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.money.integration;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigLong;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.task.ISingleLongValueTask;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import com.feed_the_beast.mods.money.FTBMoney;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MoneyTask
extends Task
implements ISingleLongValueTask {
    public static TaskType TYPE;
    public long value = 1L;

    public MoneyTask(Quest quest) {
        super(quest);
    }

    public TaskType getType() {
        return TYPE;
    }

    public long getMaxProgress() {
        return this.value;
    }

    public String getMaxProgressString() {
        return FTBMoney.moneyString(this.value);
    }

    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74772_a("value", this.value);
    }

    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.value = nbt.func_74763_f("value");
    }

    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeVarLong(this.value);
    }

    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.value = data.readVarLong();
    }

    public ConfigLong getDefaultValue() {
        return new ConfigLong(this.value, 1L, Long.MAX_VALUE);
    }

    public void setValue(long v) {
        this.value = v;
    }

    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addLong("value", () -> this.value, v -> {
            this.value = v;
        }, 1L, 1L, Long.MAX_VALUE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.task.ftbquests.ftb_money", new Object[0]));
    }

    public String getAltTitle() {
        return TextFormatting.GOLD + FTBMoney.moneyString(this.value);
    }

    public boolean consumesResources() {
        return true;
    }

    public TaskData createData(QuestData data) {
        return new Data(this, data);
    }

    @SideOnly(value=Side.CLIENT)
    public void addMouseOverText(List<String> list, @Nullable TaskData data) {
        list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbmoney.balance", (Object[])new Object[0]) + ": " + TextFormatting.GOLD + FTBMoney.moneyString(FTBMoney.getMoney((EntityPlayer)Minecraft.func_71410_x().field_71439_g)));
    }

    public static class Data
    extends TaskData<MoneyTask> {
        private Data(MoneyTask task, QuestData data) {
            super((Task)task, data);
        }

        public String getProgressString() {
            return FTBMoney.moneyString(this.progress);
        }

        public void submitTask(EntityPlayerMP player, ItemStack item) {
            long money = FTBMoney.getMoney((EntityPlayer)player);
            long add = Math.min(money, ((MoneyTask)this.task).value - this.progress);
            if (add > 0L) {
                FTBMoney.setMoney((EntityPlayer)player, money - add);
                this.addProgress(add);
            }
        }
    }
}

