/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.standalone.command;

import aroma1997.backup.common.util.IOHelper;
import aroma1997.backup.standalone.command.Command;
import aroma1997.backup.standalone.command.CommandRegistry;
import aroma1997.backup.standalone.command.ICommandRegistry;

public final class CommandHelp
extends Command {
    private ICommandRegistry commandRegistry;

    public CommandHelp(ICommandRegistry registry) {
        super("help");
        this.commandRegistry = registry;
    }

    @Override
    public void execute(String[] args) {
        if (args.length < 1) {
            if (this.commandRegistry == CommandRegistry.getInstance()) {
                IOHelper.printUserOut("The following commands are available:");
                for (Command command : CommandRegistry.getInstance().getRegisteredCommands()) {
                    IOHelper.printUserOut(command.getDescr());
                }
            } else {
                IOHelper.printUserOut("This is not a valid command. Please enter a valid command name.");
            }
            return;
        }
        Command command = this.commandRegistry.getCommand(args[0]);
        if (command == CommandRegistry.UNKNOWN_COMMAND) {
            IOHelper.printUserOut("This is not a valid command. Please enter a valid command name.");
            return;
        }
        command.printCommandUsage();
    }
}

