/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.common.storageformat;

import aroma1997.backup.common.compression.ICompression;
import aroma1997.backup.common.notification.NotificationHelper;
import aroma1997.backup.common.storageformat.BasicBackupInfo;
import aroma1997.backup.common.storageformat.IBackupInfo;
import aroma1997.backup.common.storageformat.IBackupRestoreInfo;
import aroma1997.backup.common.storageformat.IBackupStats;
import aroma1997.backup.common.storageformat.IStorageFormat;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class StorageFormatRegistry
extends Enum<StorageFormatRegistry> {
    public static final /* enum */ StorageFormatRegistry INSTANCE = new StorageFormatRegistry();
    public BiFunction<ICompression, String, IStorageFormat<? extends BasicBackupInfo>> getCompressionStorageFormat;
    public Function<IStorageFormat<? extends BasicBackupInfo>, IStorageFormat<?>> getIncrementalStorageFormat;
    private final List<IStorageFormat<?>> registeredFormats = new ArrayList();
    private static final /* synthetic */ StorageFormatRegistry[] $VALUES;

    public static StorageFormatRegistry[] values() {
        return (StorageFormatRegistry[])$VALUES.clone();
    }

    public static StorageFormatRegistry valueOf(String name) {
        return Enum.valueOf(StorageFormatRegistry.class, name);
    }

    public <T extends IBackupInfo> void registerStorageFormat(final IStorageFormat<T> format) {
        if (this.getStorageFormat(format.getFormatIdentifier()) != null) {
            throw new IllegalArgumentException("Tried to register format " + format.getFormatIdentifier() + ", but was already registered.");
        }
        this.registeredFormats.add(new IStorageFormat<T>(){

            @Override
            public List<T> listBackups(File location) throws IOException {
                return format.listBackups(location);
            }

            @Override
            public T getBackupInfo(String identifier) throws IOException {
                return format.getBackupInfo(identifier);
            }

            @Override
            public T createBackup(IBackupInfo parentBackup, File targetFile, Map<File, String> files, int compression, IBackupStats backupStats) throws IOException {
                NotificationHelper.INSTANCE.backupCreateStart(files);
                Object ret = format.createBackup(parentBackup, targetFile, files, compression, backupStats);
                NotificationHelper.INSTANCE.backupCreateEnd((IBackupInfo)ret);
                return ret;
            }

            @Override
            public void restoreBackup(T backup, IBackupRestoreInfo target) throws IOException {
                target = NotificationHelper.INSTANCE.backupRestoreStart((IBackupInfo)backup, target);
                format.restoreBackup(backup, target);
                NotificationHelper.INSTANCE.backupCreateEnd((IBackupInfo)backup);
            }

            @Override
            public String getFormatIdentifier() {
                return format.getFormatIdentifier();
            }
        });
    }

    public List<IBackupInfo> listBackups(File directory) throws IOException {
        LinkedList<IBackupInfo> ret = new LinkedList<IBackupInfo>();
        for (IStorageFormat<?> format : this.registeredFormats) {
            ret.addAll(format.listBackups(directory));
        }
        File[] recurse = directory.listFiles();
        if (recurse != null) {
            for (File sub : recurse) {
                ret.addAll(this.listBackups(sub));
            }
        }
        return ret;
    }

    public IBackupInfo getBackupInfo(String identifier) throws IOException {
        IStorageFormat<?> format;
        Iterator<IStorageFormat<?>> iter = this.registeredFormats.iterator();
        IBackupInfo ret = null;
        while (iter.hasNext() && (ret = (IBackupInfo)(format = iter.next()).getBackupInfo(identifier)) == null) {
        }
        while (iter.hasNext()) {
            format = iter.next();
            assert (format.getBackupInfo(identifier) == null);
        }
        return ret;
    }

    public IStorageFormat<?> getStorageFormat(String identifier) {
        return this.registeredFormats.stream().filter(f -> f.getFormatIdentifier().equals(identifier)).findFirst().orElse(null);
    }

    public Collection<IStorageFormat<?>> getRegisteredStorageFormats() {
        return this.registeredFormats;
    }

    static {
        $VALUES = new StorageFormatRegistry[]{INSTANCE};
    }
}

