/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles.crafting;

import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.container.InventoryFake;
import thaumcraft.common.entities.EntitySpecialItem;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;
import thaumcraft.common.tiles.TileThaumcraft;

public class TileCrucible
extends TileThaumcraft
implements ITickable,
IFluidHandler,
IAspectContainer {
    public short heat = 0;
    public AspectList aspects = new AspectList();
    public final int maxTags = 500;
    int bellows = -1;
    private int delay = 0;
    private long counter = -100L;
    int prevcolor = 0;
    int prevx = 0;
    int prevy = 0;
    public FluidTank tank = new FluidTank(FluidRegistry.WATER, 0, 1000);

    @Override
    public void readSyncNBT(NBTTagCompound nbttagcompound) {
        this.heat = nbttagcompound.func_74765_d("Heat");
        this.tank.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("Empty")) {
            this.tank.setFluid(null);
        }
        this.aspects.readFromNBT(nbttagcompound);
    }

    @Override
    public NBTTagCompound writeSyncNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74777_a("Heat", this.heat);
        this.tank.writeToNBT(nbttagcompound);
        this.aspects.writeToNBT(nbttagcompound);
        return nbttagcompound;
    }

    public void func_73660_a() {
        ++this.counter;
        short prevheat = this.heat;
        if (!this.field_145850_b.field_72995_K) {
            if (this.tank.getFluidAmount() > 0) {
                IBlockState block = this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b());
                if (block.func_185904_a() == Material.field_151587_i || block.func_185904_a() == Material.field_151581_o || BlocksTC.nitor.containsValue(block.func_177230_c()) || block.func_177230_c() == Blocks.field_189877_df) {
                    if (this.heat < 200) {
                        this.heat = (short)(this.heat + 1);
                        if (prevheat < 151 && this.heat >= 151) {
                            this.func_70296_d();
                            this.syncTile(false);
                        }
                    }
                } else if (this.heat > 0) {
                    this.heat = (short)(this.heat - 1);
                    if (this.heat == 149) {
                        this.func_70296_d();
                        this.syncTile(false);
                    }
                }
            } else if (this.heat > 0) {
                this.heat = (short)(this.heat - 1);
            }
            if (this.aspects.visSize() > 500) {
                this.spillRandom();
            }
            if (this.counter >= 100L) {
                this.spillRandom();
                this.counter = 0L;
            }
        } else if (this.tank.getFluidAmount() > 0) {
            this.drawEffects();
        }
        if (this.field_145850_b.field_72995_K && prevheat < 151 && this.heat >= 151) {
            this.heat = (short)(this.heat + 1);
        }
    }

    private void drawEffects() {
        if (this.heat > 150) {
            FXDispatcher.INSTANCE.crucibleFroth((float)this.field_174879_c.func_177958_n() + 0.2f + this.field_145850_b.field_73012_v.nextFloat() * 0.6f, (float)this.field_174879_c.func_177956_o() + this.getFluidHeight(), (float)this.field_174879_c.func_177952_p() + 0.2f + this.field_145850_b.field_73012_v.nextFloat() * 0.6f);
            if (this.aspects.visSize() > 500) {
                for (int a = 0; a < 2; ++a) {
                    FXDispatcher.INSTANCE.crucibleFrothDown(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, (float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat());
                    FXDispatcher.INSTANCE.crucibleFrothDown(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o() + 1, (float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat());
                    FXDispatcher.INSTANCE.crucibleFrothDown((float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p());
                    FXDispatcher.INSTANCE.crucibleFrothDown((float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() + 1);
                }
            }
        }
        if (this.field_145850_b.field_73012_v.nextInt(6) == 0 && this.aspects.size() > 0) {
            int color = this.aspects.getAspects()[this.field_145850_b.field_73012_v.nextInt(this.aspects.size())].getColor() + -16777216;
            int x = 5 + this.field_145850_b.field_73012_v.nextInt(22);
            int y = 5 + this.field_145850_b.field_73012_v.nextInt(22);
            this.delay = this.field_145850_b.field_73012_v.nextInt(10);
            this.prevcolor = color;
            this.prevx = x;
            this.prevy = y;
            Color c = new Color(color);
            float r = (float)c.getRed() / 255.0f;
            float g = (float)c.getGreen() / 255.0f;
            float b = (float)c.getBlue() / 255.0f;
            FXDispatcher.INSTANCE.crucibleBubble((float)this.field_174879_c.func_177958_n() + (float)x / 32.0f + 0.015625f, (float)this.field_174879_c.func_177956_o() + 0.05f + this.getFluidHeight(), (float)this.field_174879_c.func_177952_p() + (float)y / 32.0f + 0.015625f, r, g, b);
        }
    }

    public void ejectItem(ItemStack items) {
        boolean first = true;
        do {
            ItemStack spitout;
            if ((spitout = items.func_77946_l()).func_190916_E() > spitout.func_77976_d()) {
                spitout.func_190920_e(spitout.func_77976_d());
            }
            items.func_190918_g(spitout.func_190916_E());
            EntitySpecialItem entityitem = new EntitySpecialItem(this.field_145850_b, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.71f, (float)this.field_174879_c.func_177952_p() + 0.5f, spitout);
            entityitem.field_70181_x = 0.075f;
            entityitem.field_70159_w = first ? 0.0 : (double)((this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.01f);
            entityitem.field_70179_y = first ? 0.0 : (double)((this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.01f);
            this.field_145850_b.func_72838_d((Entity)entityitem);
            first = false;
        } while (items.func_190916_E() > 0);
    }

    public ItemStack attemptSmelt(ItemStack item, String username) {
        boolean bubble = false;
        boolean craftDone = false;
        int stacksize = item.func_190916_E();
        EntityPlayer player = this.field_145850_b.func_72924_a(username);
        for (int a = 0; a < stacksize; ++a) {
            CrucibleRecipe rc = ThaumcraftCraftingManager.findMatchingCrucibleRecipe(player, this.aspects, item);
            if (rc != null && this.tank.getFluidAmount() > 0) {
                ItemStack out = rc.getRecipeOutput().func_77946_l();
                if (player != null) {
                    FMLCommonHandler.instance().firePlayerCraftingEvent(player, out, (IInventory)new InventoryFake(item));
                }
                this.aspects = rc.removeMatching(this.aspects);
                this.tank.drain(50, true);
                this.ejectItem(out);
                craftDone = true;
                --stacksize;
                this.counter = -250L;
                continue;
            }
            AspectList ot = ThaumcraftCraftingManager.getObjectTags(item);
            if (ot == null || ot.size() == 0) continue;
            for (Aspect tag : ot.getAspects()) {
                this.aspects.add(tag, ot.getAmount(tag));
            }
            bubble = true;
            --stacksize;
            this.counter = -150L;
        }
        if (bubble) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.bubble, SoundCategory.BLOCKS, 0.2f, 1.0f + this.field_145850_b.field_73012_v.nextFloat() * 0.4f);
            this.syncTile(false);
            this.field_145850_b.func_175641_c(this.field_174879_c, BlocksTC.crucible, 2, 1);
        }
        if (craftDone) {
            this.syncTile(false);
            this.field_145850_b.func_175641_c(this.field_174879_c, BlocksTC.crucible, 99, 0);
        }
        this.func_70296_d();
        if (stacksize <= 0) {
            return null;
        }
        item.func_190920_e(stacksize);
        return item;
    }

    public void attemptSmelt(EntityItem entity) {
        NBTTagCompound itemData;
        String username;
        ItemStack item = entity.func_92059_d();
        ItemStack res = this.attemptSmelt(item, username = (itemData = entity.getEntityData()).func_74779_i("thrower"));
        if (res == null || res.func_190916_E() <= 0) {
            entity.func_70106_y();
        } else {
            item.func_190920_e(res.func_190916_E());
            entity.func_92058_a(item);
        }
    }

    public float getFluidHeight() {
        float base = 0.3f + 0.5f * ((float)this.tank.getFluidAmount() / (float)this.tank.getCapacity());
        float out = base + (float)this.aspects.visSize() / 500.0f * (1.0f - base);
        if (out > 1.0f) {
            out = 1.001f;
        }
        if (out == 1.0f) {
            out = 0.9999f;
        }
        return out;
    }

    public void spillRandom() {
        if (this.aspects.size() > 0) {
            Aspect tag = this.aspects.getAspects()[this.field_145850_b.field_73012_v.nextInt(this.aspects.getAspects().length)];
            this.aspects.remove(tag, 1);
            AuraHelper.polluteAura(this.field_145850_b, this.func_174877_v(), tag == Aspect.FLUX ? 1.0f : 0.25f, true);
        }
        this.func_70296_d();
        this.syncTile(false);
    }

    public void spillRemnants() {
        int vs = this.aspects.visSize();
        if (this.tank.getFluidAmount() > 0 || vs > 0) {
            this.tank.setFluid(null);
            AuraHelper.polluteAura(this.field_145850_b, this.func_174877_v(), (float)vs * 0.25f, true);
            int f = this.aspects.getAmount(Aspect.FLUX);
            if (f > 0) {
                AuraHelper.polluteAura(this.field_145850_b, this.func_174877_v(), (float)f * 0.75f, false);
            }
            this.aspects = new AspectList();
            this.field_145850_b.func_175641_c(this.field_174879_c, BlocksTC.crucible, 2, 5);
            this.func_70296_d();
            this.syncTile(false);
        }
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 99) {
            if (this.field_145850_b.field_72995_K) {
                FXDispatcher.INSTANCE.drawBamf((double)this.field_174879_c.func_177958_n() + 0.5, (float)this.field_174879_c.func_177956_o() + 1.25f, (double)this.field_174879_c.func_177952_p() + 0.5, true, true, EnumFacing.UP);
                this.field_145850_b.func_184134_a((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), SoundsTC.spill, SoundCategory.BLOCKS, 0.2f, 1.0f, false);
            }
            return true;
        }
        if (i == 1) {
            if (this.field_145850_b.field_72995_K) {
                FXDispatcher.INSTANCE.drawBamf(this.field_174879_c.func_177984_a(), true, true, EnumFacing.UP);
            }
            return true;
        }
        if (i == 2) {
            this.field_145850_b.func_184134_a((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), SoundsTC.spill, SoundCategory.BLOCKS, 0.2f, 1.0f, false);
            if (this.field_145850_b.field_72995_K) {
                for (int q = 0; q < 10; ++q) {
                    FXDispatcher.INSTANCE.crucibleBoil(this.field_174879_c, this, j);
                }
            }
            return true;
        }
        return super.func_145842_c(i, j);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1));
    }

    @Override
    public AspectList getAspects() {
        return this.aspects;
    }

    @Override
    public void setAspects(AspectList aspects) {
    }

    @Override
    public int addToContainer(Aspect tag, int amount) {
        return 0;
    }

    @Override
    public boolean takeFromContainer(Aspect tag, int amount) {
        return false;
    }

    @Override
    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    @Override
    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return false;
    }

    @Override
    public boolean doesContainerContain(AspectList ot) {
        return false;
    }

    @Override
    public int containerContains(Aspect tag) {
        return 0;
    }

    @Override
    public boolean doesContainerAccept(Aspect tag) {
        return true;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        this.func_70296_d();
        this.syncTile(false);
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack fs = this.tank.drain(resource, doDrain);
        this.func_70296_d();
        this.syncTile(false);
        return fs;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack fs = this.tank.drain(maxDrain, doDrain);
        this.func_70296_d();
        this.syncTile(false);
        return fs;
    }
}

