/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.golems.seals;

import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.Thaumcraft;
import thaumcraft.api.golems.seals.ISeal;
import thaumcraft.api.golems.seals.ISealEntity;
import thaumcraft.api.golems.seals.SealPos;
import thaumcraft.api.golems.tasks.Task;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.golems.seals.SealEntity;
import thaumcraft.common.golems.tasks.TaskHandler;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.misc.PacketSealToClient;
import thaumcraft.common.world.aura.AuraHandler;

public class SealHandler {
    public static LinkedHashMap<String, ISeal> types = new LinkedHashMap();
    private static int lastID = 0;
    public static ConcurrentHashMap<Integer, ConcurrentHashMap<SealPos, SealEntity>> sealEntities = new ConcurrentHashMap();
    static int count = 0;

    public static void registerSeal(ISeal seal) {
        if (types.containsKey(seal.getKey())) {
            Thaumcraft.log.error("Attempting to register Seal [" + seal.getKey() + "] twice. Ignoring.");
        } else {
            types.put(seal.getKey(), seal);
        }
    }

    public static String[] getRegisteredSeals() {
        return types.keySet().toArray(new String[0]);
    }

    public static ISeal getSeal(String key) {
        return types.get(key);
    }

    public static CopyOnWriteArrayList<SealEntity> getSealsInRange(World world, BlockPos source, int range) {
        CopyOnWriteArrayList<SealEntity> out = new CopyOnWriteArrayList<SealEntity>();
        ConcurrentHashMap<SealPos, SealEntity> list = sealEntities.get(world.field_73011_w.getDimension());
        if (list != null && list.size() > 0) {
            for (SealEntity se : list.values()) {
                if (se.getSeal() == null || se.getSealPos() == null || !(se.sealPos.pos.func_177951_i((Vec3i)source) <= (double)(range * range))) continue;
                out.add(se);
            }
        }
        return out;
    }

    public static CopyOnWriteArrayList<SealEntity> getSealsInChunk(World world, ChunkPos chunk) {
        CopyOnWriteArrayList<SealEntity> out = new CopyOnWriteArrayList<SealEntity>();
        ConcurrentHashMap<SealPos, SealEntity> list = sealEntities.get(world.field_73011_w.getDimension());
        if (list != null && list.size() > 0) {
            for (SealEntity se : list.values()) {
                ChunkPos cc;
                if (se.getSeal() == null || se.getSealPos() == null || !(cc = new ChunkPos(se.sealPos.pos)).equals((Object)chunk)) continue;
                out.add(se);
            }
        }
        return out;
    }

    public static void removeSealEntity(World world, SealPos pos, boolean quiet) {
        ConcurrentHashMap<SealPos, SealEntity> se;
        if (!sealEntities.containsKey(world.field_73011_w.getDimension())) {
            sealEntities.put(world.field_73011_w.getDimension(), new ConcurrentHashMap());
        }
        if ((se = sealEntities.get(world.field_73011_w.getDimension())) != null) {
            block10: {
                SealEntity seal = se.remove(pos);
                try {
                    if (!world.field_72995_K && seal != null && seal.seal != null) {
                        seal.seal.onRemoval(world, pos.pos, pos.face);
                    }
                    if (quiet || seal == null || world.field_72995_K) break block10;
                    String[] rs = SealHandler.getRegisteredSeals();
                    int indx = 1;
                    for (String s : rs) {
                        if (s.equals(seal.getSeal().getKey())) {
                            world.func_72838_d((Entity)new EntityItem(world, (double)pos.pos.func_177958_n() + 0.5 + (double)((float)pos.face.func_82601_c() / 1.7f), (double)pos.pos.func_177956_o() + 0.5 + (double)((float)pos.face.func_96559_d() / 1.7f), (double)pos.pos.func_177952_p() + 0.5 + (double)((float)pos.face.func_82599_e() / 1.7f), new ItemStack(ItemsTC.seals, 1, indx)));
                            break;
                        }
                        ++indx;
                    }
                }
                catch (Exception e) {
                    Thaumcraft.log.warn("Removing invalid seal at " + pos.pos);
                }
            }
            ConcurrentHashMap<Integer, Task> ts = TaskHandler.getTasks(world.field_73011_w.getDimension());
            for (Task task : ts.values()) {
                if (task.getSealPos() == null || !task.getSealPos().equals(pos)) continue;
                task.setSuspended(true);
            }
            if (!world.field_72995_K) {
                PacketHandler.INSTANCE.sendToDimension((IMessage)new PacketSealToClient(new SealEntity(world, pos, null)), world.field_73011_w.getDimension());
            }
            if (!quiet) {
                SealHandler.markChunkAsDirty(world.field_73011_w.getDimension(), pos.pos);
            }
        }
    }

    public static ISealEntity getSealEntity(int dim, SealPos pos) {
        if (!sealEntities.containsKey(dim)) {
            sealEntities.put(dim, new ConcurrentHashMap());
        }
        if (pos == null) {
            return null;
        }
        ConcurrentHashMap<SealPos, SealEntity> se = sealEntities.get(dim);
        if (se != null) {
            return se.get(pos);
        }
        return null;
    }

    public static boolean addSealEntity(World world, BlockPos pos, EnumFacing face, ISeal seal, EntityPlayer player) {
        SealPos sp;
        ConcurrentHashMap<SealPos, SealEntity> se;
        if (!sealEntities.containsKey(world.field_73011_w.getDimension())) {
            sealEntities.put(world.field_73011_w.getDimension(), new ConcurrentHashMap());
        }
        if ((se = sealEntities.get(world.field_73011_w.getDimension())).containsKey(sp = new SealPos(pos, face))) {
            return false;
        }
        SealEntity sealent = new SealEntity(world, sp, seal);
        sealent.setOwner(player.func_110124_au().toString());
        se.put(sp, sealent);
        if (!world.field_72995_K) {
            sealent.syncToClient(world);
            SealHandler.markChunkAsDirty(world.field_73011_w.getDimension(), pos);
        }
        return true;
    }

    public static boolean addSealEntity(World world, SealEntity seal) {
        ConcurrentHashMap<SealPos, SealEntity> se;
        if (world == null || sealEntities == null) {
            return false;
        }
        if (!sealEntities.containsKey(world.field_73011_w.getDimension())) {
            sealEntities.put(world.field_73011_w.getDimension(), new ConcurrentHashMap());
        }
        if ((se = sealEntities.get(world.field_73011_w.getDimension())).containsKey(seal.getSealPos())) {
            return false;
        }
        se.put(seal.getSealPos(), seal);
        if (!world.field_72995_K) {
            seal.syncToClient(world);
            SealHandler.markChunkAsDirty(world.field_73011_w.getDimension(), seal.getSealPos().pos);
        }
        return true;
    }

    public static void tickSealEntities(World world) {
        if (!sealEntities.containsKey(world.field_73011_w.getDimension())) {
            sealEntities.put(world.field_73011_w.getDimension(), new ConcurrentHashMap());
        }
        ConcurrentHashMap<SealPos, SealEntity> se = sealEntities.get(world.field_73011_w.getDimension());
        ++count;
        for (SealEntity sealEntity : se.values()) {
            if (!world.func_175667_e(sealEntity.sealPos.pos)) continue;
            try {
                boolean tick = true;
                if (count % 20 == 0 && !sealEntity.seal.canPlaceAt(world, sealEntity.sealPos.pos, sealEntity.sealPos.face)) {
                    SealHandler.removeSealEntity(world, sealEntity.sealPos, false);
                    tick = false;
                }
                if (!tick) continue;
                sealEntity.tickSealEntity(world);
            }
            catch (Exception e) {
                SealHandler.removeSealEntity(world, sealEntity.sealPos, false);
            }
        }
    }

    public static void markChunkAsDirty(int dim, BlockPos bp) {
        CopyOnWriteArrayList<ChunkPos> dc;
        ChunkPos pos = new ChunkPos(bp);
        if (!AuraHandler.dirtyChunks.containsKey(dim)) {
            AuraHandler.dirtyChunks.put(dim, new CopyOnWriteArrayList());
        }
        if (!(dc = AuraHandler.dirtyChunks.get(dim)).contains(pos)) {
            dc.add(pos);
        }
    }
}

